import { HTMLAttributes, CSSProperties } from 'vue';
declare type ColSpanType = number | string;
declare type FlexType = number | 'none' | 'auto' | string;
export interface ColSize {
    span?: ColSpanType;
    order?: ColSpanType;
    offset?: ColSpanType;
    push?: ColSpanType;
    pull?: ColSpanType;
}
export interface ColProps extends HTMLAttributes {
    span?: ColSpanType;
    order?: ColSpanType;
    offset?: ColSpanType;
    push?: ColSpanType;
    pull?: ColSpanType;
    xs?: ColSpanType | ColSize;
    sm?: ColSpanType | ColSize;
    md?: ColSpanType | ColSize;
    lg?: ColSpanType | ColSize;
    xl?: ColSpanType | ColSize;
    xxl?: ColSpanType | ColSize;
    prefixCls?: string;
    flex?: FlexType;
}
declare const ACol: import("vue").DefineComponent<ColProps, {}, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, import("vue").EmitsOptions, string, import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<{
    class: any;
    inlist: any;
} & {
    style?: string | CSSProperties;
    span?: import("../_util/type").Key;
    title?: string;
    onCopy?: (payload: ClipboardEvent) => void;
    onCut?: (payload: ClipboardEvent) => void;
    onPaste?: (payload: ClipboardEvent) => void;
    onCompositionend?: (payload: CompositionEvent) => void;
    onCompositionstart?: (payload: CompositionEvent) => void;
    onCompositionupdate?: (payload: CompositionEvent) => void;
    onDrag?: (payload: DragEvent) => void;
    onDragend?: (payload: DragEvent) => void;
    onDragenter?: (payload: DragEvent) => void;
    onDragexit?: (payload: DragEvent) => void;
    onDragleave?: (payload: DragEvent) => void;
    onDragover?: (payload: DragEvent) => void;
    onDragstart?: (payload: DragEvent) => void;
    onDrop?: (payload: DragEvent) => void;
    onFocus?: (payload: FocusEvent) => void;
    onBlur?: (payload: FocusEvent) => void;
    onChange?: (payload: Event) => void;
    onBeforeinput?: (payload: Event) => void;
    onInput?: (payload: Event) => void;
    onReset?: (payload: Event) => void;
    onSubmit?: (payload: Event) => void;
    onInvalid?: (payload: Event) => void;
    onLoad?: (payload: Event) => void;
    onError?: (payload: Event) => void;
    onKeydown?: (payload: KeyboardEvent) => void;
    onKeypress?: (payload: KeyboardEvent) => void;
    onKeyup?: (payload: KeyboardEvent) => void;
    onAuxclick?: (payload: MouseEvent) => void;
    onClick?: (payload: MouseEvent) => void;
    onContextmenu?: (payload: MouseEvent) => void;
    onDblclick?: (payload: MouseEvent) => void;
    onMousedown?: (payload: MouseEvent) => void;
    onMouseenter?: (payload: MouseEvent) => void;
    onMouseleave?: (payload: MouseEvent) => void;
    onMousemove?: (payload: MouseEvent) => void;
    onMouseout?: (payload: MouseEvent) => void;
    onMouseover?: (payload: MouseEvent) => void;
    onMouseup?: (payload: MouseEvent) => void;
    onAbort?: (payload: Event) => void;
    onCanplay?: (payload: Event) => void;
    onCanplaythrough?: (payload: Event) => void;
    onDurationchange?: (payload: Event) => void;
    onEmptied?: (payload: Event) => void;
    onEncrypted?: (payload: Event) => void;
    onEnded?: (payload: Event) => void;
    onLoadeddata?: (payload: Event) => void;
    onLoadedmetadata?: (payload: Event) => void;
    onLoadstart?: (payload: Event) => void;
    onPause?: (payload: Event) => void;
    onPlay?: (payload: Event) => void;
    onPlaying?: (payload: Event) => void;
    onProgress?: (payload: Event) => void;
    onRatechange?: (payload: Event) => void;
    onSeeked?: (payload: Event) => void;
    onSeeking?: (payload: Event) => void;
    onStalled?: (payload: Event) => void;
    onSuspend?: (payload: Event) => void;
    onTimeupdate?: (payload: Event) => void;
    onVolumechange?: (payload: Event) => void;
    onWaiting?: (payload: Event) => void;
    onSelect?: (payload: Event) => void;
    onScroll?: (payload: UIEvent) => void;
    onTouchcancel?: (payload: TouchEvent) => void;
    onTouchend?: (payload: TouchEvent) => void;
    onTouchmove?: (payload: TouchEvent) => void;
    onTouchstart?: (payload: TouchEvent) => void;
    onPointerdown?: (payload: PointerEvent) => void;
    onPointermove?: (payload: PointerEvent) => void;
    onPointerup?: (payload: PointerEvent) => void;
    onPointercancel?: (payload: PointerEvent) => void;
    onPointerenter?: (payload: PointerEvent) => void;
    onPointerleave?: (payload: PointerEvent) => void;
    onPointerover?: (payload: PointerEvent) => void;
    onPointerout?: (payload: PointerEvent) => void;
    onWheel?: (payload: WheelEvent) => void;
    onAnimationstart?: (payload: AnimationEvent) => void;
    onAnimationend?: (payload: AnimationEvent) => void;
    onAnimationiteration?: (payload: AnimationEvent) => void;
    onTransitionend?: (payload: TransitionEvent) => void;
    onTransitionstart?: (payload: TransitionEvent) => void;
    prefixCls?: string;
    push?: import("../_util/type").Key;
    role?: string;
    offset?: import("../_util/type").Key;
    flex?: import("../_util/type").Key;
    hidden?: boolean;
    color?: string;
    contextmenu?: string;
    id?: string;
    tabindex?: number;
    placeholder?: string;
    prefix?: string;
    lg?: string | number | ColSize;
    sm?: string | number | ColSize;
    dir?: string;
    innerHTML?: string;
    accesskey?: string;
    contenteditable?: boolean | "inherit" | "false" | "true";
    draggable?: boolean | "false" | "true";
    lang?: string;
    spellcheck?: boolean | "false" | "true";
    translate?: "yes" | "no";
    radiogroup?: string;
    about?: string;
    datatype?: string;
    property?: string;
    resource?: string;
    typeof?: string;
    vocab?: string;
    autocapitalize?: string;
    autocorrect?: string;
    autocave?: string;
    itemprop?: string;
    itemscope?: boolean;
    itemtype?: string;
    itemid?: string;
    itemref?: string;
    results?: number;
    security?: string;
    unselectable?: "on" | "off";
    inputmode?: "text" | "none" | "search" | "tel" | "url" | "email" | "numeric" | "decimal";
    is?: string;
    "aria-activedescendant"?: string;
    "aria-atomic"?: boolean | "false" | "true";
    "aria-autocomplete"?: "none" | "inline" | "both" | "list";
    "aria-busy"?: boolean | "false" | "true";
    "aria-checked"?: boolean | "false" | "true" | "mixed";
    "aria-colcount"?: number;
    "aria-colindex"?: number;
    "aria-colspan"?: number;
    "aria-controls"?: string;
    "aria-current"?: boolean | "time" | "false" | "true" | "page" | "step" | "location" | "date";
    "aria-describedby"?: string;
    "aria-details"?: string;
    "aria-disabled"?: boolean | "false" | "true";
    "aria-dropeffect"?: "link" | "none" | "copy" | "move" | "popup" | "execute";
    "aria-errormessage"?: string;
    "aria-expanded"?: boolean | "false" | "true";
    "aria-flowto"?: string;
    "aria-grabbed"?: boolean | "false" | "true";
    "aria-haspopup"?: boolean | "dialog" | "menu" | "false" | "true" | "grid" | "listbox" | "tree";
    "aria-hidden"?: boolean | "false" | "true";
    "aria-invalid"?: boolean | "false" | "true" | "grammar" | "spelling";
    "aria-keyshortcuts"?: string;
    "aria-label"?: string;
    "aria-labelledby"?: string;
    "aria-level"?: number;
    "aria-live"?: "off" | "polite" | "assertive";
    "aria-modal"?: boolean | "false" | "true";
    "aria-multiline"?: boolean | "false" | "true";
    "aria-multiselectable"?: boolean | "false" | "true";
    "aria-orientation"?: "horizontal" | "vertical";
    "aria-owns"?: string;
    "aria-placeholder"?: string;
    "aria-posinset"?: number;
    "aria-pressed"?: boolean | "false" | "true" | "mixed";
    "aria-readonly"?: boolean | "false" | "true";
    "aria-relevant"?: "text" | "all" | "additions" | "additions text" | "removals";
    "aria-required"?: boolean | "false" | "true";
    "aria-roledescription"?: string;
    "aria-rowcount"?: number;
    "aria-rowindex"?: number;
    "aria-rowspan"?: number;
    "aria-selected"?: boolean | "false" | "true";
    "aria-setsize"?: number;
    "aria-sort"?: "none" | "ascending" | "descending" | "other";
    "aria-valuemax"?: number;
    "aria-valuemin"?: number;
    "aria-valuenow"?: number;
    "aria-valuetext"?: string;
    xs?: string | number | ColSize;
    md?: string | number | ColSize;
    xl?: string | number | ColSize;
    xxl?: string | number | ColSize;
    order?: import("../_util/type").Key;
    pull?: import("../_util/type").Key;
}>, {
    class: any;
    inlist: any;
}>;
export declare const ColSize: import("vue-types").VueTypeLooseShape<{
    span: import("../_util/type").Key;
    order: import("../_util/type").Key;
    offset: import("../_util/type").Key;
    push: import("../_util/type").Key;
    pull: import("../_util/type").Key;
}>;
export default ACol;
