function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

import { inject, defineComponent } from 'vue';
import PropTypes from '../_util/vue-types';
import defaultLocaleData from './default';
export default defineComponent({
  name: 'LocaleReceiver',
  props: {
    componentName: PropTypes.string,
    defaultLocale: {
      type: [Object, Function]
    },
    children: {
      type: Function
    }
  },
  setup: function setup() {
    return {
      localeData: inject('localeData', {})
    };
  },
  methods: {
    getLocale: function getLocale() {
      var _this$componentName = this.componentName,
          componentName = _this$componentName === void 0 ? 'global' : _this$componentName,
          defaultLocale = this.defaultLocale;
      var locale = defaultLocale || defaultLocaleData[componentName || 'global'];
      var antLocale = this.localeData.antLocale;
      var localeFromContext = componentName && antLocale ? antLocale[componentName] : {};
      return _extends(_extends({}, typeof locale === 'function' ? locale() : locale), localeFromContext || {});
    },
    getLocaleCode: function getLocaleCode() {
      var antLocale = this.localeData.antLocale;
      var localeCode = antLocale && antLocale.locale; // Had use LocaleProvide but didn't set locale

      if (antLocale && antLocale.exist && !localeCode) {
        return defaultLocaleData.locale;
      }

      return localeCode;
    }
  },
  render: function render() {
    var $slots = this.$slots;
    var children = this.children || $slots.default;
    var antLocale = this.localeData.antLocale;
    return children === null || children === void 0 ? void 0 : children(this.getLocale(), this.getLocaleCode(), antLocale);
  }
});