import { createVNode as _createVNode, isVNode as _isVNode } from "vue";

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

import { defineComponent, inject } from 'vue';
import { Item, itemProps } from '../vc-menu';
import { getOptionProps, getSlot } from '../_util/props-util';
import Tooltip from '../tooltip';
import { injectExtraPropsKey } from '../vc-menu/FunctionProvider';

function _isSlot(s) {
  return typeof s === 'function' || Object.prototype.toString.call(s) === '[object Object]' && !_isVNode(s);
}

export default defineComponent({
  name: 'MenuItem',
  inheritAttrs: false,
  props: itemProps,
  isMenuItem: true,
  setup: function setup() {
    return {
      getInlineCollapsed: inject('getInlineCollapsed', function () {
        return false;
      }),
      layoutSiderContext: inject('layoutSiderContext', {}),
      injectExtraProps: inject(injectExtraPropsKey, function () {
        return {};
      })
    };
  },
  methods: {
    onKeyDown: function onKeyDown(e) {
      this.$refs.menuItem.onKeyDown(e);
    }
  },
  render: function render() {
    var props = getOptionProps(this);

    var _Object$assign = _extends(_extends({}, props), this.injectExtraProps),
        level = _Object$assign.level,
        title = _Object$assign.title,
        rootPrefixCls = _Object$assign.rootPrefixCls;

    var getInlineCollapsed = this.getInlineCollapsed,
        attrs = this.$attrs;
    var inlineCollapsed = getInlineCollapsed();
    var tooltipTitle = title;
    var children = getSlot(this);

    if (typeof title === 'undefined') {
      tooltipTitle = level === 1 ? children : '';
    } else if (title === false) {
      tooltipTitle = '';
    }

    var tooltipProps = {
      title: tooltipTitle
    };
    var siderCollapsed = this.layoutSiderContext.sCollapsed;

    if (!siderCollapsed && !inlineCollapsed) {
      tooltipProps.title = null; // Reset `visible` to fix control mode tooltip display not correct
      // ref: https://github.com/ant-design/ant-design/issues/16742

      tooltipProps.visible = false;
    }

    var itemProps = _extends(_extends(_extends(_extends({}, props), {
      title: title
    }), attrs), {
      ref: 'menuItem'
    });

    var toolTipProps = _extends(_extends({}, tooltipProps), {
      placement: 'right',
      overlayClassName: "".concat(rootPrefixCls, "-inline-collapsed-tooltip")
    });

    var item = _createVNode(Item, itemProps, _isSlot(children) ? children : {
      default: function _default() {
        return [children];
      }
    });

    return _createVNode(Tooltip, toolTipProps, _isSlot(item) ? item : {
      default: function _default() {
        return [item];
      }
    });
  }
});