import { createVNode as _createVNode, resolveDirective as _resolveDirective } from "vue";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

import { defineComponent, inject } from 'vue';
import { SubMenu as VcSubMenu } from '../vc-menu';
import classNames from '../_util/classNames';
import { injectExtraPropsKey } from '../vc-menu/FunctionProvider';
export default defineComponent({
  name: 'ASubMenu',
  isSubMenu: true,
  inheritAttrs: false,
  props: _extends({}, VcSubMenu.props),
  setup: function setup() {
    return {
      menuPropsContext: inject('menuPropsContext', {}),
      injectExtraProps: inject(injectExtraPropsKey, function () {
        return {};
      })
    };
  },
  methods: {
    onKeyDown: function onKeyDown(e) {
      this.$refs.subMenu.onKeyDown(e);
    }
  },
  render: function render() {
    var $slots = this.$slots,
        $attrs = this.$attrs;

    var _Object$assign = _extends(_extends({}, this.$props), this.injectExtraProps),
        rootPrefixCls = _Object$assign.rootPrefixCls,
        popupClassName = _Object$assign.popupClassName;

    var antdMenuTheme = this.menuPropsContext.theme;

    var props = _extends(_extends(_extends({}, this.$props), {
      popupClassName: classNames("".concat(rootPrefixCls, "-").concat(antdMenuTheme), popupClassName),
      ref: 'subMenu'
    }), $attrs);

    return _createVNode(VcSubMenu, props, _objectSpread({}, $slots));
  }
});