import { ExtractPropTypes, VNodeTypes, CSSProperties, PropType } from 'vue';
import { ButtonType, ButtonProps } from '../button/buttonTypes';
declare const ButtonProps: {
    prefixCls: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    type: import("vue-types").VueTypeDef<"default" | "link" | "dashed" | "primary" | "ghost" | "danger">;
    htmlType: import("vue-types").VueTypeDef<"button" | "reset" | "submit"> & {
        default: "button" | "reset" | "submit";
    };
    shape: import("vue-types").VueTypeDef<"circle" | "round" | "circle-outline">;
    size: import("vue-types").VueTypeDef<"default" | "small" | "large"> & {
        default: "default" | "small" | "large";
    };
    loading: import("vue-types").VueTypeDef<boolean | {
        [key: string]: any;
    }>;
    disabled: import("vue-types").VueTypeValidableDef<boolean>;
    ghost: import("vue-types").VueTypeValidableDef<boolean>;
    block: import("vue-types").VueTypeValidableDef<boolean>;
    icon: import("vue-types").VueTypeValidableDef<import("../_util/type").VueNode>;
    href: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    title: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    onClick: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
};
declare const ButtonType: import("vue-types").VueTypeDef<"default" | "link" | "dashed" | "primary" | "ghost" | "danger">;
declare const modalProps: {
    prefixCls: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    /** 对话框是否可见*/
    visible: import("vue-types").VueTypeValidableDef<boolean>;
    /** 确定按钮 loading*/
    confirmLoading: import("vue-types").VueTypeValidableDef<boolean>;
    /** 标题*/
    title: import("vue-types").VueTypeValidableDef<any>;
    /** 是否显示右上角的关闭按钮*/
    closable: import("vue-types").VueTypeValidableDef<boolean>;
    closeIcon: import("vue-types").VueTypeValidableDef<any>;
    /** 点击确定回调*/
    onOk: {
        type: PropType<(e: MouseEvent) => void>;
    };
    /** 点击模态框右上角叉、取消按钮、Props.maskClosable 值为 true 时的遮罩层或键盘按下 Esc 时的回调*/
    onCancel: {
        type: PropType<(e: MouseEvent) => void>;
    };
    afterClose: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    } & {
        default: (...args: any[]) => any;
    };
    /** 垂直居中 */
    centered: import("vue-types").VueTypeValidableDef<boolean>;
    /** 宽度*/
    width: import("vue-types").VueTypeDef<import("../_util/type").Key>;
    /** 底部内容*/
    footer: import("vue-types").VueTypeValidableDef<any>;
    /** 确认按钮文字*/
    okText: import("vue-types").VueTypeValidableDef<any>;
    /** 确认按钮类型*/
    okType: import("vue-types").VueTypeDef<"default" | "link" | "dashed" | "primary" | "ghost" | "danger">;
    /** 取消按钮文字*/
    cancelText: import("vue-types").VueTypeValidableDef<any>;
    icon: import("vue-types").VueTypeValidableDef<any>;
    /** 点击蒙层是否允许关闭*/
    maskClosable: import("vue-types").VueTypeValidableDef<boolean>;
    /** 强制渲染 Modal*/
    forceRender: import("vue-types").VueTypeValidableDef<boolean>;
    okButtonProps: import("vue-types").VueTypeShape<{
        prefixCls: string;
        type: "default" | "link" | "dashed" | "primary" | "ghost" | "danger";
        htmlType: "button" | "reset" | "submit";
        shape: "circle" | "round" | "circle-outline";
        size: "default" | "small" | "large";
        loading: boolean | {
            [key: string]: any;
        };
        disabled: boolean;
        ghost: boolean;
        block: boolean;
        icon: void | JSX.Element;
        href: string;
        title: string;
        onClick: any;
    }>;
    cancelButtonProps: import("vue-types").VueTypeShape<{
        prefixCls: string;
        type: "default" | "link" | "dashed" | "primary" | "ghost" | "danger";
        htmlType: "button" | "reset" | "submit";
        shape: "circle" | "round" | "circle-outline";
        size: "default" | "small" | "large";
        loading: boolean | {
            [key: string]: any;
        };
        disabled: boolean;
        ghost: boolean;
        block: boolean;
        icon: void | JSX.Element;
        href: string;
        title: string;
        onClick: any;
    }>;
    destroyOnClose: import("vue-types").VueTypeValidableDef<boolean>;
    wrapClassName: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    maskTransitionName: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    transitionName: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    getContainer: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    zIndex: import("vue-types").VueTypeValidableDef<number> & {
        default: number;
    };
    bodyStyle: import("vue-types").VueTypeValidableDef<CSSProperties>;
    maskStyle: import("vue-types").VueTypeValidableDef<CSSProperties>;
    mask: import("vue-types").VueTypeValidableDef<boolean>;
    keyboard: import("vue-types").VueTypeValidableDef<boolean>;
    wrapProps: import("vue-types").VueTypeValidableDef<{
        [key: string]: any;
    }> & {
        default: () => {
            [key: string]: any;
        };
    };
    focusTriggerAfterClose: import("vue-types").VueTypeValidableDef<boolean>;
};
export declare type ModalProps = ExtractPropTypes<typeof modalProps>;
export interface ModalFuncProps {
    prefixCls?: string;
    class?: string;
    visible?: boolean;
    title?: VNodeTypes;
    content?: VNodeTypes;
    onOk?: (...args: any[]) => any;
    onCancel?: (...args: any[]) => any;
    okButtonProps?: ButtonProps;
    cancelButtonProps?: ButtonProps;
    centered?: boolean;
    width?: string | number;
    okText?: VNodeTypes;
    okType?: ButtonType;
    cancelText?: VNodeTypes;
    icon?: VNodeTypes;
    iconType?: string;
    mask?: boolean;
    maskClosable?: boolean;
    zIndex?: number;
    okCancel?: boolean;
    style?: CSSProperties | string;
    maskStyle?: CSSProperties;
    type?: string;
    keyboard?: boolean;
    getContainer?: getContainerFunc;
    autoFocusButton?: null | 'ok' | 'cancel';
    transitionName?: string;
    maskTransitionName?: string;
}
declare type getContainerFunc = () => HTMLElement;
export declare type ModalFunc = (props: ModalFuncProps) => {
    destroy: () => void;
    update: (newConfig: ModalFuncProps) => void;
};
export interface ModalLocale {
    okText: string;
    cancelText: string;
    justOkText: string;
}
export declare const destroyFns: any[];
declare const _default: import("vue").DefineComponent<{
    prefixCls: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    /** 对话框是否可见*/
    visible: import("vue-types").VueTypeValidableDef<boolean>;
    /** 确定按钮 loading*/
    confirmLoading: import("vue-types").VueTypeValidableDef<boolean>;
    /** 标题*/
    title: import("vue-types").VueTypeValidableDef<any>;
    /** 是否显示右上角的关闭按钮*/
    closable: import("vue-types").VueTypeValidableDef<boolean>;
    closeIcon: import("vue-types").VueTypeValidableDef<any>;
    /** 点击确定回调*/
    onOk: {
        type: PropType<(e: MouseEvent) => void>;
    };
    /** 点击模态框右上角叉、取消按钮、Props.maskClosable 值为 true 时的遮罩层或键盘按下 Esc 时的回调*/
    onCancel: {
        type: PropType<(e: MouseEvent) => void>;
    };
    afterClose: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    } & {
        default: (...args: any[]) => any;
    };
    /** 垂直居中 */
    centered: import("vue-types").VueTypeValidableDef<boolean>;
    /** 宽度*/
    width: import("vue-types").VueTypeDef<import("../_util/type").Key>;
    /** 底部内容*/
    footer: import("vue-types").VueTypeValidableDef<any>;
    /** 确认按钮文字*/
    okText: import("vue-types").VueTypeValidableDef<any>;
    /** 确认按钮类型*/
    okType: import("vue-types").VueTypeDef<"default" | "link" | "dashed" | "primary" | "ghost" | "danger">;
    /** 取消按钮文字*/
    cancelText: import("vue-types").VueTypeValidableDef<any>;
    icon: import("vue-types").VueTypeValidableDef<any>;
    /** 点击蒙层是否允许关闭*/
    maskClosable: import("vue-types").VueTypeValidableDef<boolean>;
    /** 强制渲染 Modal*/
    forceRender: import("vue-types").VueTypeValidableDef<boolean>;
    okButtonProps: import("vue-types").VueTypeShape<{
        prefixCls: string;
        type: "default" | "link" | "dashed" | "primary" | "ghost" | "danger";
        htmlType: "button" | "reset" | "submit";
        shape: "circle" | "round" | "circle-outline";
        size: "default" | "small" | "large";
        loading: boolean | {
            [key: string]: any;
        };
        disabled: boolean;
        ghost: boolean;
        block: boolean;
        icon: void | JSX.Element;
        href: string;
        title: string;
        onClick: any;
    }>;
    cancelButtonProps: import("vue-types").VueTypeShape<{
        prefixCls: string;
        type: "default" | "link" | "dashed" | "primary" | "ghost" | "danger";
        htmlType: "button" | "reset" | "submit";
        shape: "circle" | "round" | "circle-outline";
        size: "default" | "small" | "large";
        loading: boolean | {
            [key: string]: any;
        };
        disabled: boolean;
        ghost: boolean;
        block: boolean;
        icon: void | JSX.Element;
        href: string;
        title: string;
        onClick: any;
    }>;
    destroyOnClose: import("vue-types").VueTypeValidableDef<boolean>;
    wrapClassName: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    maskTransitionName: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    transitionName: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    getContainer: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    zIndex: import("vue-types").VueTypeValidableDef<number> & {
        default: number;
    };
    bodyStyle: import("vue-types").VueTypeValidableDef<CSSProperties>;
    maskStyle: import("vue-types").VueTypeValidableDef<CSSProperties>;
    mask: import("vue-types").VueTypeValidableDef<boolean>;
    keyboard: import("vue-types").VueTypeValidableDef<boolean>;
    wrapProps: import("vue-types").VueTypeValidableDef<{
        [key: string]: any;
    }> & {
        default: () => {
            [key: string]: any;
        };
    };
    focusTriggerAfterClose: import("vue-types").VueTypeValidableDef<boolean>;
}, {
    configProvider: import("../config-provider").ConfigConsumerProps;
}, {
    sVisible: boolean;
}, {}, {
    handleCancel(e: MouseEvent): void;
    handleOk(e: MouseEvent): void;
    renderFooter(locale: ModalLocale): JSX.Element;
}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, ("change" | "cancel" | "update:visible" | "ok")[], "change" | "cancel" | "update:visible" | "ok", import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<{
    prefixCls: string;
    transitionName: string;
    zIndex: number;
    maskTransitionName: string;
    afterClose: (...args: any[]) => any;
    getContainer: (...args: any[]) => any;
    wrapClassName: string;
    wrapProps: {
        [key: string]: any;
    };
} & {
    icon?: any;
    footer?: any;
    title?: any;
    mask?: boolean;
    keyboard?: boolean;
    visible?: boolean;
    forceRender?: boolean;
    maskClosable?: boolean;
    width?: import("../_util/type").Key;
    bodyStyle?: CSSProperties;
    closable?: boolean;
    centered?: boolean;
    closeIcon?: any;
    onOk?: (e: MouseEvent) => void;
    destroyOnClose?: boolean;
    maskStyle?: CSSProperties;
    focusTriggerAfterClose?: boolean;
    confirmLoading?: boolean;
    okType?: "default" | "link" | "dashed" | "primary" | "ghost" | "danger";
    onCancel?: (e: MouseEvent) => void;
    okText?: any;
    cancelText?: any;
    okButtonProps?: {
        prefixCls: string;
        type: "default" | "link" | "dashed" | "primary" | "ghost" | "danger";
        htmlType: "button" | "reset" | "submit";
        shape: "circle" | "round" | "circle-outline";
        size: "default" | "small" | "large";
        loading: boolean | {
            [key: string]: any;
        };
        disabled: boolean;
        ghost: boolean;
        block: boolean;
        icon: void | JSX.Element;
        href: string;
        title: string;
        onClick: any;
    };
    cancelButtonProps?: {
        prefixCls: string;
        type: "default" | "link" | "dashed" | "primary" | "ghost" | "danger";
        htmlType: "button" | "reset" | "submit";
        shape: "circle" | "round" | "circle-outline";
        size: "default" | "small" | "large";
        loading: boolean | {
            [key: string]: any;
        };
        disabled: boolean;
        ghost: boolean;
        block: boolean;
        icon: void | JSX.Element;
        href: string;
        title: string;
        onClick: any;
    };
}>, {
    prefixCls: string;
    transitionName: string;
    zIndex: number;
    maskTransitionName: string;
    afterClose: (...args: any[]) => any;
    getContainer: (...args: any[]) => any;
    wrapClassName: string;
    wrapProps: {
        [key: string]: any;
    };
}>;
export default _default;
