import { createVNode as _createVNode, isVNode as _isVNode } from "vue";

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import { defineComponent, inject } from 'vue';
import PropTypes from '../_util/vue-types';
import { getComponent, getOptionProps, getSlot } from '../_util/props-util';
import { defaultConfigProvider } from '../config-provider';
import ArrowLeftOutlined from '@ant-design/icons-vue/ArrowLeftOutlined';
import Breadcrumb from '../breadcrumb';
import Avatar from '../avatar';
import TransButton from '../_util/transButton';
import LocaleReceiver from '../locale-provider/LocaleReceiver';
import { withInstall } from '../_util/type';

function _isSlot(s) {
  return typeof s === 'function' || Object.prototype.toString.call(s) === '[object Object]' && !_isVNode(s);
}

export var PageHeaderProps = {
  backIcon: PropTypes.VNodeChild,
  prefixCls: PropTypes.string,
  title: PropTypes.VNodeChild,
  subTitle: PropTypes.VNodeChild,
  breadcrumb: PropTypes.object,
  tags: PropTypes.any,
  footer: PropTypes.VNodeChild,
  extra: PropTypes.VNodeChild,
  avatar: PropTypes.object,
  ghost: PropTypes.looseBool,
  onBack: PropTypes.func
};

var renderBack = function renderBack(instance, prefixCls, backIcon, onBack) {
  if (!backIcon || !onBack) {
    return null;
  }

  return _createVNode(LocaleReceiver, {
    "componentName": "PageHeader",
    "children": function children(_ref) {
      var back = _ref.back;
      return _createVNode("div", {
        "class": "".concat(prefixCls, "-back")
      }, [_createVNode(TransButton, {
        "onClick": function onClick(e) {
          instance.$emit('back', e);
        },
        "class": "".concat(prefixCls, "-back-button"),
        "aria-label": back
      }, _isSlot(backIcon) ? backIcon : {
        default: function _default() {
          return [backIcon];
        }
      })]);
    }
  }, null);
};

var renderBreadcrumb = function renderBreadcrumb(breadcrumb) {
  return _createVNode(Breadcrumb, breadcrumb, null);
};

var renderTitle = function renderTitle(prefixCls, instance) {
  var avatar = instance.avatar;
  var title = getComponent(instance, 'title');
  var subTitle = getComponent(instance, 'subTitle');
  var tags = getComponent(instance, 'tags');
  var extra = getComponent(instance, 'extra');
  var backIcon = getComponent(instance, 'backIcon') !== undefined ? getComponent(instance, 'backIcon') : _createVNode(ArrowLeftOutlined, null, null);
  var onBack = instance.onBack;
  var headingPrefixCls = "".concat(prefixCls, "-heading");

  if (title || subTitle || tags || extra) {
    var backIconDom = renderBack(instance, prefixCls, backIcon, onBack);
    return _createVNode("div", {
      "class": headingPrefixCls
    }, [backIconDom, avatar && _createVNode(Avatar, avatar, null), title && _createVNode("span", {
      "class": "".concat(headingPrefixCls, "-title")
    }, _isSlot(title) ? title : {
      default: function _default() {
        return [title];
      }
    }), subTitle && _createVNode("span", {
      "class": "".concat(headingPrefixCls, "-sub-title")
    }, _isSlot(subTitle) ? subTitle : {
      default: function _default() {
        return [subTitle];
      }
    }), tags && _createVNode("span", {
      "class": "".concat(headingPrefixCls, "-tags")
    }, _isSlot(tags) ? tags : {
      default: function _default() {
        return [tags];
      }
    }), extra && _createVNode("span", {
      "class": "".concat(headingPrefixCls, "-extra")
    }, _isSlot(extra) ? extra : {
      default: function _default() {
        return [extra];
      }
    })]);
  }

  return null;
};

var renderFooter = function renderFooter(prefixCls, footer) {
  if (footer) {
    return _createVNode("div", {
      "class": "".concat(prefixCls, "-footer")
    }, _isSlot(footer) ? footer : {
      default: function _default() {
        return [footer];
      }
    });
  }

  return null;
};

var renderChildren = function renderChildren(prefixCls, children) {
  return _createVNode("div", {
    "class": "".concat(prefixCls, "-content")
  }, _isSlot(children) ? children : {
    default: function _default() {
      return [children];
    }
  });
};

var PageHeader = defineComponent({
  name: 'APageHeader',
  props: PageHeaderProps,
  setup: function setup() {
    return {
      configProvider: inject('configProvider', defaultConfigProvider)
    };
  },
  render: function render() {
    var _this$configProvider = this.configProvider,
        getPrefixCls = _this$configProvider.getPrefixCls,
        pageHeader = _this$configProvider.pageHeader;
    var props = getOptionProps(this);
    var customizePrefixCls = props.prefixCls,
        breadcrumb = props.breadcrumb;
    var footer = getComponent(this, 'footer');
    var children = getSlot(this);
    var ghost = true; // Use `ghost` from `props` or from `ConfigProvider` instead.

    if ('ghost' in props) {
      ghost = props.ghost;
    } else if (pageHeader && 'ghost' in pageHeader) {
      ghost = pageHeader.ghost;
    }

    var prefixCls = getPrefixCls('page-header', customizePrefixCls);
    var breadcrumbDom = breadcrumb && breadcrumb.routes ? renderBreadcrumb(breadcrumb) : null;
    var className = [prefixCls, _defineProperty({
      'has-breadcrumb': breadcrumbDom,
      'has-footer': footer
    }, "".concat(prefixCls, "-ghost"), ghost)];
    return _createVNode("div", {
      "class": className
    }, [breadcrumbDom, renderTitle(prefixCls, this), children.length ? renderChildren(prefixCls, children) : null, renderFooter(prefixCls, footer)]);
  }
});
export default withInstall(PageHeader);