import { isVNode as _isVNode, createVNode as _createVNode } from "vue";
import { defineComponent, inject } from 'vue';
import PropTypes from '../_util/vue-types';
import { tuple } from '../_util/type';
import { getComponent } from '../_util/props-util';
import { defaultConfigProvider } from '../config-provider';
import CheckCircleFilled from '@ant-design/icons-vue/CheckCircleFilled';
import CloseCircleFilled from '@ant-design/icons-vue/CloseCircleFilled';
import ExclamationCircleFilled from '@ant-design/icons-vue/ExclamationCircleFilled';
import WarningFilled from '@ant-design/icons-vue/WarningFilled';
import noFound from './noFound';
import serverError from './serverError';
import unauthorized from './unauthorized';

function _isSlot(s) {
  return typeof s === 'function' || Object.prototype.toString.call(s) === '[object Object]' && !_isVNode(s);
}

export var IconMap = {
  success: CheckCircleFilled,
  error: CloseCircleFilled,
  info: ExclamationCircleFilled,
  warning: WarningFilled
};
export var ExceptionMap = {
  '404': noFound,
  '500': serverError,
  '403': unauthorized
}; // ExceptionImageMap keys

var ExceptionStatus = Object.keys(ExceptionMap);
export var ResultProps = {
  prefixCls: PropTypes.string,
  icon: PropTypes.any,
  status: PropTypes.oneOf(tuple('success', 'error', 'info', 'warning', '404', '403', '500')).def('info'),
  title: PropTypes.any,
  subTitle: PropTypes.any,
  extra: PropTypes.any
};

var renderIcon = function renderIcon(prefixCls, _ref) {
  var status = _ref.status,
      icon = _ref.icon;

  if (ExceptionStatus.includes("".concat(status))) {
    var SVGComponent = ExceptionMap[status];
    return _createVNode("div", {
      "class": "".concat(prefixCls, "-icon ").concat(prefixCls, "-image")
    }, [_createVNode(SVGComponent, null, null)]);
  }

  var IconComponent = IconMap[status];

  var iconNode = icon || _createVNode(IconComponent, null, null);

  return _createVNode("div", {
    "class": "".concat(prefixCls, "-icon")
  }, _isSlot(iconNode) ? iconNode : {
    default: function _default() {
      return [iconNode];
    }
  });
};

var renderExtra = function renderExtra(prefixCls, extra) {
  return extra && _createVNode("div", {
    "class": "".concat(prefixCls, "-extra")
  }, _isSlot(extra) ? extra : {
    default: function _default() {
      return [extra];
    }
  });
};

var Result = defineComponent({
  name: 'AResult',
  props: ResultProps,
  setup: function setup() {
    return {
      configProvider: inject('configProvider', defaultConfigProvider)
    };
  },
  render: function render() {
    var customizePrefixCls = this.prefixCls,
        status = this.status;
    var getPrefixCls = this.configProvider.getPrefixCls;
    var prefixCls = getPrefixCls('result', customizePrefixCls);
    var title = getComponent(this, 'title');
    var subTitle = getComponent(this, 'subTitle');
    var icon = getComponent(this, 'icon');
    var extra = getComponent(this, 'extra');
    return _createVNode("div", {
      "class": "".concat(prefixCls, " ").concat(prefixCls, "-").concat(status)
    }, [renderIcon(prefixCls, {
      status: status,
      icon: icon
    }), _createVNode("div", {
      "class": "".concat(prefixCls, "-title")
    }, _isSlot(title) ? title : {
      default: function _default() {
        return [title];
      }
    }), subTitle && _createVNode("div", {
      "class": "".concat(prefixCls, "-subtitle")
    }, _isSlot(subTitle) ? subTitle : {
      default: function _default() {
        return [subTitle];
      }
    }), this.$slots.default && _createVNode("div", {
      "class": "".concat(prefixCls, "-content")
    }, [this.$slots.default()]), renderExtra(prefixCls, extra)]);
  }
});
/* add resource */

Result.PRESENTED_IMAGE_403 = ExceptionMap[403];
Result.PRESENTED_IMAGE_404 = ExceptionMap[404];
Result.PRESENTED_IMAGE_500 = ExceptionMap[500];
/* istanbul ignore next */

Result.install = function (app) {
  app.component(Result.name, Result);
  return app;
};

export default Result;