import { createVNode as _createVNode } from "vue";
import { defineComponent } from 'vue';
import PropTypes from '../_util/vue-types';
var skeletonTitleProps = {
  prefixCls: PropTypes.string,
  width: PropTypes.oneOfType([PropTypes.number, PropTypes.string])
};
export var SkeletonTitleProps = PropTypes.shape(skeletonTitleProps);
var Title = defineComponent({
  props: skeletonTitleProps,
  render: function render() {
    var _this$$props = this.$props,
        prefixCls = _this$$props.prefixCls,
        width = _this$$props.width;
    var zWidth = typeof width === 'number' ? "".concat(width, "px") : width;
    return _createVNode("h3", {
      "class": prefixCls,
      "style": {
        width: zWidth
      }
    }, null);
  }
});
export default Title;