import { createVNode as _createVNode } from "vue";

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

import { defineComponent, inject } from 'vue';
import classNames from '../_util/classNames';
import PropTypes, { withUndefined } from '../_util/vue-types';
import { initDefaultProps, hasProp } from '../_util/props-util';
import { defaultConfigProvider } from '../config-provider';
import Avatar, { SkeletonAvatarProps } from './Avatar';
import Title, { SkeletonTitleProps } from './Title';
import Paragraph, { SkeletonParagraphProps } from './Paragraph';
import { withInstall } from '../_util/type';
export var SkeletonProps = {
  active: PropTypes.looseBool,
  loading: PropTypes.looseBool,
  prefixCls: PropTypes.string,
  children: PropTypes.any,
  avatar: withUndefined(PropTypes.oneOfType([PropTypes.string, SkeletonAvatarProps, PropTypes.looseBool])),
  title: withUndefined(PropTypes.oneOfType([PropTypes.looseBool, PropTypes.string, SkeletonTitleProps])),
  paragraph: withUndefined(PropTypes.oneOfType([PropTypes.looseBool, PropTypes.string, SkeletonParagraphProps]))
};

function getComponentProps(prop) {
  if (prop && _typeof(prop) === 'object') {
    return prop;
  }

  return {};
}

function getAvatarBasicProps(hasTitle, hasParagraph) {
  if (hasTitle && !hasParagraph) {
    return {
      shape: 'square'
    };
  }

  return {
    shape: 'circle'
  };
}

function getTitleBasicProps(hasAvatar, hasParagraph) {
  if (!hasAvatar && hasParagraph) {
    return {
      width: '38%'
    };
  }

  if (hasAvatar && hasParagraph) {
    return {
      width: '50%'
    };
  }

  return {};
}

function getParagraphBasicProps(hasAvatar, hasTitle) {
  var basicProps = {}; // Width

  if (!hasAvatar || !hasTitle) {
    basicProps.width = '61%';
  } // Rows


  if (!hasAvatar && hasTitle) {
    basicProps.rows = 3;
  } else {
    basicProps.rows = 2;
  }

  return basicProps;
}

var Skeleton = defineComponent({
  name: 'ASkeleton',
  props: initDefaultProps(SkeletonProps, {
    avatar: false,
    title: true,
    paragraph: true
  }),
  setup: function setup() {
    return {
      configProvider: inject('configProvider', defaultConfigProvider)
    };
  },
  render: function render() {
    var _a, _b;

    var _this$$props = this.$props,
        customizePrefixCls = _this$$props.prefixCls,
        loading = _this$$props.loading,
        avatar = _this$$props.avatar,
        title = _this$$props.title,
        paragraph = _this$$props.paragraph,
        active = _this$$props.active;
    var getPrefixCls = this.configProvider.getPrefixCls;
    var prefixCls = getPrefixCls('skeleton', customizePrefixCls);

    if (loading || !hasProp(this, 'loading')) {
      var _classNames;

      var hasAvatar = !!avatar || avatar === '';
      var hasTitle = !!title;
      var hasParagraph = !!paragraph; // Avatar

      var avatarNode;

      if (hasAvatar) {
        var avatarProps = _extends(_extends({
          prefixCls: "".concat(prefixCls, "-avatar")
        }, getAvatarBasicProps(hasTitle, hasParagraph)), getComponentProps(avatar));

        avatarNode = _createVNode("div", {
          "class": "".concat(prefixCls, "-header")
        }, [_createVNode(Avatar, avatarProps, null)]);
      }

      var contentNode;

      if (hasTitle || hasParagraph) {
        // Title
        var $title;

        if (hasTitle) {
          var titleProps = _extends(_extends({
            prefixCls: "".concat(prefixCls, "-title")
          }, getTitleBasicProps(hasAvatar, hasParagraph)), getComponentProps(title));

          $title = _createVNode(Title, titleProps, null);
        } // Paragraph


        var paragraphNode;

        if (hasParagraph) {
          var paragraphProps = _extends(_extends({
            prefixCls: "".concat(prefixCls, "-paragraph")
          }, getParagraphBasicProps(hasAvatar, hasTitle)), getComponentProps(paragraph));

          paragraphNode = _createVNode(Paragraph, paragraphProps, null);
        }

        contentNode = _createVNode("div", {
          "class": "".concat(prefixCls, "-content")
        }, [$title, paragraphNode]);
      }

      var cls = classNames(prefixCls, (_classNames = {}, _defineProperty(_classNames, "".concat(prefixCls, "-with-avatar"), hasAvatar), _defineProperty(_classNames, "".concat(prefixCls, "-active"), active), _classNames));
      return _createVNode("div", {
        "class": cls
      }, [avatarNode, contentNode]);
    }

    return (_b = (_a = this.$slots).default) === null || _b === void 0 ? void 0 : _b.call(_a);
  }
});
export default withInstall(Skeleton);