import { isVNode as _isVNode, createVNode as _createVNode } from "vue";

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var __rest = this && this.__rest || function (s, e) {
  var t = {};

  for (var p in s) {
    if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  }

  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};

import { defineComponent, inject } from 'vue';
import LoadingOutlined from '@ant-design/icons-vue/LoadingOutlined';
import PropTypes from '../_util/vue-types';
import hasProp, { getOptionProps, getComponent } from '../_util/props-util';
import VcSwitch from '../vc-switch';
import Wave from '../_util/wave';
import { defaultConfigProvider } from '../config-provider';
import warning from '../_util/warning';
import { tuple, withInstall } from '../_util/type';

function _isSlot(s) {
  return typeof s === 'function' || Object.prototype.toString.call(s) === '[object Object]' && !_isVNode(s);
}

var Switch = defineComponent({
  name: 'ASwitch',
  __ANT_SWITCH: true,
  inheritAttrs: false,
  props: {
    prefixCls: PropTypes.string,
    // size=default and size=large are the same
    size: PropTypes.oneOf(tuple('small', 'default', 'large')),
    disabled: PropTypes.looseBool,
    checkedChildren: PropTypes.any,
    unCheckedChildren: PropTypes.any,
    tabindex: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
    checked: PropTypes.looseBool,
    defaultChecked: PropTypes.looseBool,
    autofocus: PropTypes.looseBool,
    loading: PropTypes.looseBool,
    onChange: PropTypes.func,
    onClick: PropTypes.func,
    'onUpdate:checked': PropTypes.func
  },
  // emits: ['change', 'click', 'update:checked'],
  setup: function setup() {
    return {
      refSwitchNode: undefined,
      configProvider: inject('configProvider', defaultConfigProvider)
    };
  },
  created: function created() {
    warning(hasProp(this, 'checked') || !('value' in this.$attrs), 'Switch', '`value` is not validate prop, do you mean `checked`?');
  },
  methods: {
    focus: function focus() {
      var _a;

      (_a = this.refSwitchNode) === null || _a === void 0 ? void 0 : _a.focus();
    },
    blur: function blur() {
      var _a;

      (_a = this.refSwitchNode) === null || _a === void 0 ? void 0 : _a.blur();
    },
    saveRef: function saveRef(c) {
      this.refSwitchNode = c;
    }
  },
  render: function render() {
    var _slot;

    var _classes;

    var _a = getOptionProps(this),
        customizePrefixCls = _a.prefixCls,
        size = _a.size,
        loading = _a.loading,
        disabled = _a.disabled,
        restProps = __rest(_a, ["prefixCls", "size", "loading", "disabled"]);

    var getPrefixCls = this.configProvider.getPrefixCls;
    var prefixCls = getPrefixCls('switch', customizePrefixCls);
    var $attrs = this.$attrs;
    var classes = (_classes = {}, _defineProperty(_classes, $attrs.class, $attrs.class), _defineProperty(_classes, "".concat(prefixCls, "-small"), size === 'small'), _defineProperty(_classes, "".concat(prefixCls, "-loading"), loading), _classes);
    var loadingIcon = loading ? _createVNode(LoadingOutlined, {
      "class": "".concat(prefixCls, "-loading-icon")
    }, null) : null;

    var switchProps = _extends(_extends(_extends({}, restProps), $attrs), {
      prefixCls: prefixCls,
      loadingIcon: loadingIcon,
      checkedChildren: getComponent(this, 'checkedChildren'),
      unCheckedChildren: getComponent(this, 'unCheckedChildren'),
      disabled: disabled || loading,
      class: classes,
      ref: this.saveRef
    });

    return _createVNode(Wave, {
      "insertExtraNode": true
    }, _isSlot(_slot = _createVNode(VcSwitch, switchProps, null)) ? _slot : {
      default: function _default() {
        return [_slot];
      }
    });
  }
});
export default withInstall(Switch);