import { createVNode as _createVNode } from "vue";

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var __rest = this && this.__rest || function (s, e) {
  var t = {};

  for (var p in s) {
    if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  }

  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};

import { defineComponent } from 'vue';
import Checkbox from '../checkbox';
import Radio from '../radio';
import { SelectionBoxProps } from './interface';
import BaseMixin from '../_util/BaseMixin';
import { getOptionProps } from '../_util/props-util';
export default defineComponent({
  name: 'SelectionBox',
  mixins: [BaseMixin],
  inheritAttrs: false,
  props: SelectionBoxProps,
  setup: function setup() {
    return {
      unsubscribe: null
    };
  },
  data: function data() {
    return {
      checked: false
    };
  },
  created: function created() {
    this.checked = this.getCheckState(this.$props);
  },
  mounted: function mounted() {
    this.subscribe();
  },
  beforeUnmount: function beforeUnmount() {
    if (this.unsubscribe) {
      this.unsubscribe();
    }
  },
  methods: {
    getCheckState: function getCheckState(props) {
      var store = props.store,
          defaultSelection = props.defaultSelection,
          rowIndex = props.rowIndex;
      var checked = false;

      if (store.getState().selectionDirty) {
        checked = store.getState().selectedRowKeys.indexOf(rowIndex) >= 0;
      } else {
        checked = store.getState().selectedRowKeys.indexOf(rowIndex) >= 0 || defaultSelection.indexOf(rowIndex) >= 0;
      }

      return checked;
    },
    subscribe: function subscribe() {
      var _this = this;

      var store = this.store;
      this.unsubscribe = store.subscribe(function () {
        var checked = _this.getCheckState(_this.$props);

        _this.setState({
          checked: checked
        });
      });
    }
  },
  render: function render() {
    var _a = _extends(_extends({}, getOptionProps(this)), this.$attrs),
        type = _a.type,
        rowIndex = _a.rowIndex,
        rest = __rest(_a, ["type", "rowIndex"]);

    var checked = this.checked;

    var checkboxProps = _extends({
      checked: checked
    }, rest);

    if (type === 'radio') {
      checkboxProps.value = rowIndex;
      return _createVNode(Radio, checkboxProps, null);
    }

    return _createVNode(Checkbox, checkboxProps, null);
  }
});