import { isVNode as _isVNode, createVNode as _createVNode } from "vue";

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

import DownOutlined from '@ant-design/icons-vue/DownOutlined';
import Checkbox from '../checkbox';
import Dropdown from '../dropdown';
import Menu from '../menu';
import classNames from '../_util/classNames';
import { SelectionCheckboxAllProps } from './interface';
import BaseMixin from '../_util/BaseMixin';
import { defineComponent } from 'vue';

function _isSlot(s) {
  return typeof s === 'function' || Object.prototype.toString.call(s) === '[object Object]' && !_isVNode(s);
}

function checkSelection(_ref) {
  var store = _ref.store,
      getCheckboxPropsByItem = _ref.getCheckboxPropsByItem,
      getRecordKey = _ref.getRecordKey,
      data = _ref.data,
      type = _ref.type,
      byDefaultChecked = _ref.byDefaultChecked;
  return byDefaultChecked ? data[type](function (item, i) {
    return getCheckboxPropsByItem(item, i).defaultChecked;
  }) : data[type](function (item, i) {
    return store.getState().selectedRowKeys.indexOf(getRecordKey(item, i)) >= 0;
  });
}

function getIndeterminateState(props) {
  var store = props.store,
      data = props.data;

  if (!data.length) {
    return false;
  }

  var someCheckedNotByDefaultChecked = checkSelection(_extends(_extends({}, props), {
    data: data,
    type: 'some',
    byDefaultChecked: false
  })) && !checkSelection(_extends(_extends({}, props), {
    data: data,
    type: 'every',
    byDefaultChecked: false
  }));
  var someCheckedByDefaultChecked = checkSelection(_extends(_extends({}, props), {
    data: data,
    type: 'some',
    byDefaultChecked: true
  })) && !checkSelection(_extends(_extends({}, props), {
    data: data,
    type: 'every',
    byDefaultChecked: true
  }));

  if (store.getState().selectionDirty) {
    return someCheckedNotByDefaultChecked;
  }

  return someCheckedNotByDefaultChecked || someCheckedByDefaultChecked;
}

function getCheckState(props) {
  var store = props.store,
      data = props.data;

  if (!data.length) {
    return false;
  }

  if (store.getState().selectionDirty) {
    return checkSelection(_extends(_extends({}, props), {
      data: data,
      type: 'every',
      byDefaultChecked: false
    }));
  }

  return checkSelection(_extends(_extends({}, props), {
    data: data,
    type: 'every',
    byDefaultChecked: false
  })) || checkSelection(_extends(_extends({}, props), {
    data: data,
    type: 'every',
    byDefaultChecked: true
  }));
}

export default defineComponent({
  name: 'SelectionCheckboxAll',
  mixins: [BaseMixin],
  inheritAttrs: false,
  props: SelectionCheckboxAllProps,
  setup: function setup() {
    return {
      defaultSelections: [],
      unsubscribe: null
    };
  },
  data: function data() {
    var props = this.$props;
    return {
      checked: getCheckState(props),
      indeterminate: getIndeterminateState(props)
    };
  },
  watch: {
    propsSymbol: {
      handler: function handler() {
        this.setCheckState(this.$props);
      }
    }
  },
  created: function created() {
    var props = this.$props;
    this.defaultSelections = props.hideDefaultSelections ? [] : [{
      key: 'all',
      text: props.locale.selectAll
    }, {
      key: 'invert',
      text: props.locale.selectInvert
    }];
  },
  mounted: function mounted() {
    this.subscribe();
  },
  beforeUnmount: function beforeUnmount() {
    if (this.unsubscribe) {
      this.unsubscribe();
    }
  },
  methods: {
    checkSelection: function checkSelection(props, data, type, byDefaultChecked) {
      var _ref2 = props || this.$props,
          store = _ref2.store,
          getCheckboxPropsByItem = _ref2.getCheckboxPropsByItem,
          getRecordKey = _ref2.getRecordKey; // type should be 'every' | 'some'


      if (type === 'every' || type === 'some') {
        return byDefaultChecked ? data[type](function (item, i) {
          return getCheckboxPropsByItem(item, i).defaultChecked;
        }) : data[type](function (item, i) {
          return store.getState().selectedRowKeys.indexOf(getRecordKey(item, i)) >= 0;
        });
      }

      return false;
    },
    setCheckState: function setCheckState(props) {
      var checked = getCheckState(props);
      var indeterminate = getIndeterminateState(props);
      this.setState(function (prevState) {
        var newState = {};

        if (indeterminate !== prevState.indeterminate) {
          newState.indeterminate = indeterminate;
        }

        if (checked !== prevState.checked) {
          newState.checked = checked;
        }

        return newState;
      });
    },
    handleSelectAllChange: function handleSelectAllChange(e) {
      var checked = e.target.checked;
      this.$emit('select', checked ? 'all' : 'removeAll', 0, null);
    },
    subscribe: function subscribe() {
      var _this = this;

      var store = this.store;
      this.unsubscribe = store.subscribe(function () {
        _this.setCheckState(_this.$props);
      });
    },
    renderMenus: function renderMenus(selections) {
      var _this2 = this;

      return selections.map(function (selection, index) {
        var _slot;

        return _createVNode(Menu.Item, {
          "key": selection.key || index
        }, _isSlot(_slot = _createVNode("div", {
          "onClick": function onClick() {
            _this2.$emit('select', selection.key, index, selection.onSelect);
          }
        }, [selection.text])) ? _slot : {
          default: function _default() {
            return [_slot];
          }
        });
      });
    }
  },
  render: function render() {
    var disabled = this.disabled,
        prefixCls = this.prefixCls,
        selections = this.selections,
        getPopupContainer = this.getPopupContainer,
        checked = this.checked,
        indeterminate = this.indeterminate;
    var selectionPrefixCls = "".concat(prefixCls, "-selection");
    var customSelections = null;

    if (selections) {
      var _slot2, _slot3;

      var newSelections = Array.isArray(selections) ? this.defaultSelections.concat(selections) : this.defaultSelections;

      var menu = _createVNode(Menu, {
        "class": "".concat(selectionPrefixCls, "-menu"),
        "selectedKeys": []
      }, _isSlot(_slot2 = this.renderMenus(newSelections)) ? _slot2 : {
        default: function _default() {
          return [_slot2];
        }
      });

      customSelections = newSelections.length > 0 ? _createVNode(Dropdown, {
        "getPopupContainer": getPopupContainer,
        "overlay": menu
      }, _isSlot(_slot3 = _createVNode("div", {
        "class": "".concat(selectionPrefixCls, "-down")
      }, [_createVNode(DownOutlined, null, null)])) ? _slot3 : {
        default: function _default() {
          return [_slot3];
        }
      }) : null;
    }

    return _createVNode("div", {
      "class": selectionPrefixCls
    }, [_createVNode(Checkbox, {
      "class": classNames(_defineProperty({}, "".concat(selectionPrefixCls, "-select-all-custom"), customSelections)),
      "checked": checked,
      "indeterminate": indeterminate,
      "disabled": disabled,
      "onChange": this.handleSelectAllChange
    }, null), customSelections]);
  }
});