import { createVNode as _createVNode, isVNode as _isVNode } from "vue";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

import PropTypes from '../_util/vue-types';
import { defineComponent } from 'vue';
import { Store } from './createStore';
import { getSlot } from '../_util/props-util';
import omit from 'omit.js';

function _isSlot(s) {
  return typeof s === 'function' || Object.prototype.toString.call(s) === '[object Object]' && !_isVNode(s);
}

var BodyRowProps = {
  store: Store,
  rowKey: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
  prefixCls: PropTypes.string
};
export default function createBodyRow() {
  var Component = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'tr';
  var BodyRow = defineComponent({
    name: 'BodyRow',
    inheritAttrs: false,
    props: BodyRowProps,
    setup: function setup() {
      return {
        unsubscribe: null
      };
    },
    data: function data() {
      var _this$store$getState = this.store.getState(),
          selectedRowKeys = _this$store$getState.selectedRowKeys;

      return {
        selected: selectedRowKeys.indexOf(this.rowKey) >= 0
      };
    },
    mounted: function mounted() {
      this.subscribe();
    },
    beforeUnmount: function beforeUnmount() {
      if (this.unsubscribe) {
        this.unsubscribe();
      }
    },
    methods: {
      subscribe: function subscribe() {
        var _this = this;

        var store = this.store,
            rowKey = this.rowKey;
        this.unsubscribe = store.subscribe(function () {
          var _this$store$getState2 = _this.store.getState(),
              selectedRowKeys = _this$store$getState2.selectedRowKeys;

          var selected = selectedRowKeys.indexOf(rowKey) >= 0;

          if (selected !== _this.selected) {
            _this.selected = selected;
          }
        });
      }
    },
    render: function render() {
      var _slot;

      var _className;

      var rowProps = omit(_extends(_extends({}, this.$props), this.$attrs), ['prefixCls', 'rowKey', 'store', 'class']);
      var className = (_className = {}, _defineProperty(_className, "".concat(this.prefixCls, "-row-selected"), this.selected), _defineProperty(_className, this.$attrs.class, !!this.$attrs.class), _className);
      return _createVNode(Component, _objectSpread({
        "class": className
      }, rowProps), _isSlot(_slot = getSlot(this)) ? _slot : {
        default: function _default() {
          return [_slot];
        }
      });
    }
  });
  return BodyRow;
}