import { isVNode as _isVNode, createVNode as _createVNode } from "vue";
import PropTypes from '../../_util/vue-types';
import Touchable from '../../vc-m-feedback';
import { getSlot } from '../../_util/props-util';

function _isSlot(s) {
  return typeof s === 'function' || Object.prototype.toString.call(s) === '[object Object]' && !_isVNode(s);
}

var InputHandler = {
  name: 'InputHandler',
  inheritAttrs: false,
  props: {
    prefixCls: PropTypes.string,
    disabled: PropTypes.looseBool
  },
  render: function render() {
    var _slot;

    var _this$$props = this.$props,
        prefixCls = _this$$props.prefixCls,
        disabled = _this$$props.disabled;
    var touchableProps = {
      disabled: disabled,
      activeClassName: "".concat(prefixCls, "-handler-active")
    };
    return _createVNode(Touchable, touchableProps, _isSlot(_slot = _createVNode("span", this.$attrs, [getSlot(this)])) ? _slot : {
      default: function _default() {
        return [_slot];
      }
    });
  }
};
export default InputHandler;