function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

import { createVNode, defineComponent, inject, provide, watch } from 'vue';
import { injectExtraPropsKey } from './FunctionProvider';
export default function wrapWithConnect(WrappedComponent) {
  var tempProps = WrappedComponent.props || {};
  var props = {};
  Object.keys(tempProps).forEach(function (k) {
    props[k] = _extends(_extends({}, tempProps[k]), {
      required: false
    });
  });
  var Connect = {
    name: "Connect_".concat(WrappedComponent.name),
    inheritAttrs: false,
    props: props,
    setup: function setup(props) {
      provide(injectExtraPropsKey, undefined); // 断掉 injectExtraPropsKey 的依赖

      var injectExtraProps = injectExtraPropsKey ? inject(injectExtraPropsKey, function () {
        return {};
      }) : {};
      watch(injectExtraProps, function () {// 神奇的问题，vue 3.0.3 之后，没能正确响应式，暂时加个 watch hack 一下
      });
      return {
        props: props,
        injectExtraProps: injectExtraProps
      };
    },
    methods: {
      getWrappedInstance: function getWrappedInstance() {
        return this.$refs.wrappedInstance;
      }
    },
    render: function render() {
      var _this$$slots = this.$slots,
          $slots = _this$$slots === void 0 ? {} : _this$$slots,
          $attrs = this.$attrs;

      var props = _extends(_extends({}, this.props), this.injectExtraProps);

      var wrapProps = _extends(_extends(_extends({}, $attrs), props), {
        ref: 'wrappedInstance'
      }); // const slots = {};
      // for (let [key, value] of Object.entries($slots)) {
      //   slots[key] = () => value();
      // }


      return createVNode(WrappedComponent, wrapProps, $slots);
    }
  };
  return defineComponent(Connect);
}