import { createVNode as _createVNode, isVNode as _isVNode } from "vue";
import PropTypes from '../../_util/vue-types';
import BaseMixin from '../../_util/BaseMixin';
import { getComponent } from '../../_util/props-util';

function _isSlot(s) {
  return typeof s === 'function' || Object.prototype.toString.call(s) === '[object Object]' && !_isVNode(s);
}

function noop() {}

export default {
  name: 'Star',
  mixins: [BaseMixin],
  inheritAttrs: false,
  props: {
    value: PropTypes.number,
    index: PropTypes.number,
    prefixCls: PropTypes.string,
    allowHalf: PropTypes.looseBool,
    disabled: PropTypes.looseBool,
    character: PropTypes.any,
    characterRender: PropTypes.func,
    focused: PropTypes.looseBool,
    count: PropTypes.number
  },
  methods: {
    onHover: function onHover(e) {
      var index = this.index;

      this.__emit('hover', e, index);
    },
    onClick: function onClick(e) {
      var index = this.index;

      this.__emit('click', e, index);
    },
    onKeyDown: function onKeyDown(e) {
      var index = this.$props.index;

      if (e.keyCode === 13) {
        this.__emit('click', e, index);
      }
    },
    getClassName: function getClassName() {
      var prefixCls = this.prefixCls,
          index = this.index,
          value = this.value,
          allowHalf = this.allowHalf,
          focused = this.focused;
      var starValue = index + 1;
      var className = prefixCls;

      if (value === 0 && index === 0 && focused) {
        className += " ".concat(prefixCls, "-focused");
      } else if (allowHalf && value + 0.5 === starValue) {
        className += " ".concat(prefixCls, "-half ").concat(prefixCls, "-active");

        if (focused) {
          className += " ".concat(prefixCls, "-focused");
        }
      } else {
        className += starValue <= value ? " ".concat(prefixCls, "-full") : " ".concat(prefixCls, "-zero");

        if (starValue === value && focused) {
          className += " ".concat(prefixCls, "-focused");
        }
      }

      return className;
    }
  },
  render: function render() {
    var onHover = this.onHover,
        onClick = this.onClick,
        onKeyDown = this.onKeyDown,
        disabled = this.disabled,
        prefixCls = this.prefixCls,
        characterRender = this.characterRender,
        index = this.index,
        count = this.count,
        value = this.value;
    var character = getComponent(this, 'character');

    var star = _createVNode("li", {
      "class": this.getClassName()
    }, [_createVNode("div", {
      "onClick": disabled ? noop : onClick,
      "onKeydown": disabled ? noop : onKeyDown,
      "onMousemove": disabled ? noop : onHover,
      "role": "radio",
      "aria-checked": value > index ? 'true' : 'false',
      "aria-posinset": index + 1,
      "aria-setsize": count,
      "tabindex": 0
    }, [_createVNode("div", {
      "class": "".concat(prefixCls, "-first")
    }, _isSlot(character) ? character : {
      default: function _default() {
        return [character];
      }
    }), _createVNode("div", {
      "class": "".concat(prefixCls, "-second")
    }, _isSlot(character) ? character : {
      default: function _default() {
        return [character];
      }
    })])]);

    if (characterRender) {
      star = characterRender(star, this.$props);
    }

    return star;
  }
};