import * as Vue from 'vue';
import { VNode } from 'vue';
import { Key, RawValueType } from './generator';
export declare type RenderDOMFunc = (props: any) => HTMLElement;
export declare type RenderNode = Vue.VNodeChild | ((props: any) => Vue.VNodeChild);
export declare type Mode = 'multiple' | 'tags' | 'combobox';
export declare type OnActiveValue = (active: RawValueType, index: number, info?: {
    source?: 'keyboard' | 'mouse';
}) => void;
export interface OptionCoreData {
    key?: Key;
    disabled?: boolean;
    value?: Key;
    title?: string;
    class?: string;
    style?: Vue.CSSProperties;
    label?: Vue.VNodeChild;
    /** @deprecated Only works when use `children` as option data */
    children?: VNode[] | JSX.Element[];
}
export interface OptionData extends OptionCoreData {
    /** Save for customize data */
    [prop: string]: any;
}
export interface OptionGroupData {
    key?: Key;
    label?: Vue.VNodeChild;
    options: OptionData[];
    class?: string;
    style?: Vue.CSSProperties;
    /** Save for customize data */
    [prop: string]: any;
}
export declare type OptionsType = (OptionData | OptionGroupData)[];
export interface FlattenOptionData {
    group?: boolean;
    groupOption?: boolean;
    key: string | number;
    data: OptionData | OptionGroupData;
}
