import { createVNode as _createVNode, isVNode as _isVNode } from "vue";
import { Text } from 'vue';
import PropTypes from '../_util/vue-types';
import { getSlot } from '../_util/props-util';

function _isSlot(s) {
  return typeof s === 'function' || Object.prototype.toString.call(s) === '[object Object]' && !_isVNode(s);
}

export default {
  name: 'LazyRenderBox',
  props: {
    visible: PropTypes.looseBool,
    hiddenClassName: PropTypes.string
  },
  render: function render() {
    var hiddenClassName = this.$props.hiddenClassName;
    var child = getSlot(this);

    if (hiddenClassName || child && child.length > 1 || child && child[0] && child[0].type === Text) {
      // const cls = '';
      // if (!visible && hiddenClassName) {
      //   // cls += ` ${hiddenClassName}`
      // }
      return _createVNode("div", null, _isSlot(child) ? child : {
        default: function _default() {
          return [child];
        }
      });
    }

    return child && child[0];
  }
};