"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = connect;

var _shallowequal = _interopRequireDefault(require("../shallowequal"));

var _vue = require("vue");

var _omit = _interopRequireDefault(require("omit.js"));

var _propsUtil = require("../props-util");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function getDisplayName(WrappedComponent) {
  return WrappedComponent.name || 'Component';
}

var defaultMapStateToProps = function defaultMapStateToProps() {
  return {};
};

function connect(mapStateToProps, injectExtraPropsKey) {
  var shouldSubscribe = !!mapStateToProps;
  var finalMapStateToProps = mapStateToProps || defaultMapStateToProps;
  return function wrapWithConnect(WrappedComponent) {
    var tempProps = (0, _omit.default)(WrappedComponent.props || {}, ['store']);
    var props = {};
    Object.keys(tempProps).forEach(function (k) {
      props[k] = _extends(_extends({}, tempProps[k]), {
        required: false
      });
    });
    var Connect = {
      name: "Connect_".concat(getDisplayName(WrappedComponent)),
      inheritAttrs: false,
      props: props,
      setup: function setup() {
        (0, _vue.provide)(injectExtraPropsKey, undefined); // 断掉 injectExtraPropsKey 的依赖

        return {
          storeContext: (0, _vue.inject)('storeContext', {}),
          injectExtraProps: injectExtraPropsKey ? (0, _vue.inject)(injectExtraPropsKey, function () {
            return {};
          }) : {}
        };
      },
      data: function data() {
        var _this = this;

        this.store = this.storeContext.store;
        this.preProps = _extends(_extends({}, (0, _propsUtil.getOptionProps)(this)), this.injectExtraProps);
        (0, _vue.watchEffect)(function () {
          if (mapStateToProps && mapStateToProps.length === 2) {
            _this.subscribed = finalMapStateToProps(_this.store.getState(), _extends(_extends({}, _this.$props), _this.injectExtraProps));
          }
        });
        return {
          subscribed: finalMapStateToProps(this.store.getState(), _extends(_extends({}, this.$props), this.injectExtraProps))
        };
      },
      mounted: function mounted() {
        this.trySubscribe();
      },
      beforeUnmount: function beforeUnmount() {
        this.tryUnsubscribe();
      },
      methods: {
        handleChange: function handleChange() {
          if (!this.unsubscribe) {
            return;
          }

          var props = _extends(_extends({}, (0, _propsUtil.getOptionProps)(this)), this.injectExtraProps);

          var nextSubscribed = finalMapStateToProps(this.store.getState(), props);

          if (!(0, _shallowequal.default)(this.preProps, props) || !(0, _shallowequal.default)(this.subscribed, nextSubscribed)) {
            this.subscribed = nextSubscribed;
          }
        },
        trySubscribe: function trySubscribe() {
          if (shouldSubscribe) {
            this.unsubscribe = this.store.subscribe(this.handleChange);
            this.handleChange();
          }
        },
        tryUnsubscribe: function tryUnsubscribe() {
          if (this.unsubscribe) {
            this.unsubscribe();
            this.unsubscribe = null;
          }
        },
        getWrappedInstance: function getWrappedInstance() {
          return this.$refs.wrappedInstance;
        }
      },
      render: function render() {
        var _this$$slots = this.$slots,
            $slots = _this$$slots === void 0 ? {} : _this$$slots,
            subscribed = this.subscribed,
            store = this.store,
            $attrs = this.$attrs;

        var props = _extends(_extends({}, (0, _propsUtil.getOptionProps)(this)), this.injectExtraProps);

        this.preProps = _extends({}, props);

        var wrapProps = _extends(_extends(_extends(_extends({}, $attrs), props), subscribed), {
          store: store,
          ref: 'wrappedInstance'
        }); // const slots = {};
        // for (let [key, value] of Object.entries($slots)) {
        //   slots[key] = () => value();
        // }


        return (0, _vue.createVNode)(WrappedComponent, wrapProps, $slots);
      }
    };
    return (0, _vue.defineComponent)(Connect);
  };
}