"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _vue = require("vue");

var _KeyCode = _interopRequireDefault(require("./KeyCode"));

var _vueTypes = _interopRequireDefault(require("./vue-types"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var inlineStyle = {
  border: 0,
  background: 'transparent',
  padding: 0,
  lineHeight: 'inherit',
  display: 'inline-block'
};
var TransButton = (0, _vue.defineComponent)({
  name: 'TransButton',
  inheritAttrs: false,
  props: {
    noStyle: _vueTypes.default.looseBool,
    onClick: _vueTypes.default.func
  },
  methods: {
    onKeyDown: function onKeyDown(event) {
      var keyCode = event.keyCode;

      if (keyCode === _KeyCode.default.ENTER) {
        event.preventDefault();
      }
    },
    onKeyUp: function onKeyUp(event) {
      var keyCode = event.keyCode;

      if (keyCode === _KeyCode.default.ENTER) {
        this.$emit('click', event);
      }
    },
    setRef: function setRef(btn) {
      this.$refs.div = btn;
    },
    focus: function focus() {
      if (this.$refs.div) {
        this.$refs.div.focus();
      }
    },
    blur: function blur() {
      if (this.$refs.div) {
        this.$refs.div.blur();
      }
    }
  },
  render: function render() {
    var _a, _b;

    var _this$$props = this.$props,
        noStyle = _this$$props.noStyle,
        onClick = _this$$props.onClick;
    return (0, _vue.createVNode)("div", _objectSpread(_objectSpread({
      "role": "button",
      "tabindex": 0,
      "ref": "div"
    }, this.$attrs), {}, {
      "onClick": onClick,
      "onKeydown": this.onKeyDown,
      "onKeyup": this.onKeyUp,
      "style": _extends({}, !noStyle ? inlineStyle : null)
    }), [(_b = (_a = this.$slots).default) === null || _b === void 0 ? void 0 : _b.call(_a)]);
  }
});
var _default = TransButton;
exports.default = _default;