"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.AlertProps = void 0;

var _vue = require("vue");

var _CloseOutlined = _interopRequireDefault(require("@ant-design/icons-vue/CloseOutlined"));

var _CheckCircleOutlined = _interopRequireDefault(require("@ant-design/icons-vue/CheckCircleOutlined"));

var _ExclamationCircleOutlined = _interopRequireDefault(require("@ant-design/icons-vue/ExclamationCircleOutlined"));

var _InfoCircleOutlined = _interopRequireDefault(require("@ant-design/icons-vue/InfoCircleOutlined"));

var _CloseCircleOutlined = _interopRequireDefault(require("@ant-design/icons-vue/CloseCircleOutlined"));

var _CheckCircleFilled = _interopRequireDefault(require("@ant-design/icons-vue/CheckCircleFilled"));

var _ExclamationCircleFilled = _interopRequireDefault(require("@ant-design/icons-vue/ExclamationCircleFilled"));

var _InfoCircleFilled = _interopRequireDefault(require("@ant-design/icons-vue/InfoCircleFilled"));

var _CloseCircleFilled = _interopRequireDefault(require("@ant-design/icons-vue/CloseCircleFilled"));

var _classNames2 = _interopRequireDefault(require("../_util/classNames"));

var _BaseMixin = _interopRequireDefault(require("../_util/BaseMixin"));

var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));

var _transition = require("../_util/transition");

var _propsUtil = require("../_util/props-util");

var _configProvider = require("../config-provider");

var _type = require("../_util/type");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _isSlot(s) {
  return typeof s === 'function' || Object.prototype.toString.call(s) === '[object Object]' && !(0, _vue.isVNode)(s);
}

function noop() {}

var iconMapFilled = {
  success: _CheckCircleFilled.default,
  info: _InfoCircleFilled.default,
  error: _CloseCircleFilled.default,
  warning: _ExclamationCircleFilled.default
};
var iconMapOutlined = {
  success: _CheckCircleOutlined.default,
  info: _InfoCircleOutlined.default,
  error: _CloseCircleOutlined.default,
  warning: _ExclamationCircleOutlined.default
};
var AlertProps = {
  /**
   * Type of Alert styles, options: `success`, `info`, `warning`, `error`
   */
  type: _vueTypes.default.oneOf((0, _type.tuple)('success', 'info', 'warning', 'error')),

  /** Whether Alert can be closed */
  closable: _vueTypes.default.looseBool,

  /** Close text to show */
  closeText: _vueTypes.default.VNodeChild,

  /** Content of Alert */
  message: _vueTypes.default.VNodeChild,

  /** Additional content of Alert */
  description: _vueTypes.default.VNodeChild,

  /** Callback when close Alert */
  // onClose?: React.MouseEventHandler<HTMLAnchorElement>;

  /** Trigger when animation ending of Alert */
  afterClose: _vueTypes.default.func.def(noop),

  /** Whether to show icon */
  showIcon: _vueTypes.default.looseBool,
  prefixCls: _vueTypes.default.string,
  banner: _vueTypes.default.looseBool,
  icon: _vueTypes.default.VNodeChild,
  onClose: _vueTypes.default.VNodeChild
};
exports.AlertProps = AlertProps;
var Alert = (0, _vue.defineComponent)({
  name: 'AAlert',
  mixins: [_BaseMixin.default],
  inheritAttrs: false,
  props: AlertProps,
  emits: ['close'],
  setup: function setup() {
    return {
      configProvider: (0, _vue.inject)('configProvider', _configProvider.defaultConfigProvider)
    };
  },
  data: function data() {
    return {
      closing: false,
      closed: false
    };
  },
  methods: {
    handleClose: function handleClose(e) {
      e.preventDefault();
      var dom = (0, _propsUtil.findDOMNode)(this);
      dom.style.height = "".concat(dom.offsetHeight, "px"); // Magic code
      // 重复一次后才能正确设置 height

      dom.style.height = "".concat(dom.offsetHeight, "px");
      this.setState({
        closing: true
      });
      this.$emit('close', e);
    },
    animationEnd: function animationEnd() {
      this.setState({
        closing: false,
        closed: true
      });
      this.afterClose();
    }
  },
  render: function render() {
    var _slot;

    var _classNames;

    var customizePrefixCls = this.prefixCls,
        banner = this.banner,
        closing = this.closing,
        closed = this.closed,
        $attrs = this.$attrs;
    var getPrefixCls = this.configProvider.getPrefixCls;
    var prefixCls = getPrefixCls('alert', customizePrefixCls);
    var closable = this.closable,
        type = this.type,
        showIcon = this.showIcon;
    var closeText = (0, _propsUtil.getComponent)(this, 'closeText');
    var description = (0, _propsUtil.getComponent)(this, 'description');
    var message = (0, _propsUtil.getComponent)(this, 'message');
    var icon = (0, _propsUtil.getComponent)(this, 'icon'); // banner模式默认有 Icon

    showIcon = banner && showIcon === undefined ? true : showIcon; // banner模式默认为警告

    type = banner && type === undefined ? 'warning' : type || 'info';
    var IconType = (description ? iconMapOutlined : iconMapFilled)[type] || null; // closeable when closeText is assigned

    if (closeText) {
      closable = true;
    }

    var alertCls = (0, _classNames2.default)(prefixCls, (_classNames = {}, _defineProperty(_classNames, "".concat(prefixCls, "-").concat(type), true), _defineProperty(_classNames, "".concat(prefixCls, "-closing"), closing), _defineProperty(_classNames, "".concat(prefixCls, "-with-description"), !!description), _defineProperty(_classNames, "".concat(prefixCls, "-no-icon"), !showIcon), _defineProperty(_classNames, "".concat(prefixCls, "-banner"), !!banner), _defineProperty(_classNames, "".concat(prefixCls, "-closable"), closable), _classNames));
    var closeIcon = closable ? (0, _vue.createVNode)("button", {
      "type": "button",
      "onClick": this.handleClose,
      "class": "".concat(prefixCls, "-close-icon"),
      "tabindex": 0
    }, [closeText ? (0, _vue.createVNode)("span", {
      "class": "".concat(prefixCls, "-close-text")
    }, _isSlot(closeText) ? closeText : {
      default: function _default() {
        return [closeText];
      }
    }) : (0, _vue.createVNode)(_CloseOutlined.default, null, null)]) : null;
    var iconNode = icon && ((0, _propsUtil.isValidElement)(icon) ? (0, _vue.cloneVNode)(icon, {
      class: "".concat(prefixCls, "-icon")
    }) : (0, _vue.createVNode)("span", {
      "class": "".concat(prefixCls, "-icon")
    }, _isSlot(icon) ? icon : {
      default: function _default() {
        return [icon];
      }
    })) || (0, _vue.createVNode)(IconType, {
      "class": "".concat(prefixCls, "-icon")
    }, null); // h(iconType, { class: `${prefixCls}-icon` });

    var transitionProps = (0, _transition.getTransitionProps)("".concat(prefixCls, "-slide-up"), {
      appear: false,
      onAfterLeave: this.animationEnd
    });
    return closed ? null : (0, _vue.createVNode)(_transition.Transition, transitionProps, _isSlot(_slot = (0, _vue.withDirectives)((0, _vue.createVNode)("div", _objectSpread(_objectSpread({}, $attrs), {}, {
      "class": [$attrs.class, alertCls],
      "data-show": !closing
    }), [showIcon ? iconNode : null, (0, _vue.createVNode)("span", {
      "class": "".concat(prefixCls, "-message")
    }, _isSlot(message) ? message : {
      default: function _default() {
        return [message];
      }
    }), (0, _vue.createVNode)("span", {
      "class": "".concat(prefixCls, "-description")
    }, _isSlot(description) ? description : {
      default: function _default() {
        return [description];
      }
    }), closeIcon]), [[_vue.vShow, !closing]])) ? _slot : {
      default: function _default() {
        return [_slot];
      }
    });
  }
});

var _default2 = (0, _type.withInstall)(Alert);

exports.default = _default2;