export declare type AnchorContainer = HTMLElement | Window;
export interface AntAnchor {
    registerLink: (link: string) => void;
    unregisterLink: (link: string) => void;
    $data: AnchorState;
    scrollTo: (link: string) => void;
    $emit?: Function;
}
export interface AnchorState {
    activeLink: null | string;
    scrollContainer: HTMLElement | Window;
    links: string[];
    scrollEvent: any;
    animating: boolean;
    sPrefixCls?: string;
}
declare const _default: import("vue").DefineComponent<{
    prefixCls: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    offsetTop: import("vue-types").VueTypeValidableDef<number> & {
        default: number;
    };
    bounds: import("vue-types").VueTypeValidableDef<number> & {
        default: number;
    };
    affix: import("vue-types").VueTypeValidableDef<boolean> & {
        default: boolean;
    };
    showInkInFixed: import("vue-types").VueTypeValidableDef<boolean> & {
        default: boolean;
    };
    getContainer: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    } & {
        default: (...args: any[]) => any;
    };
    wrapperClass: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    wrapperStyle: import("vue-types").VueTypeValidableDef<import("vue").CSSProperties>;
    getCurrentAnchor: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    targetOffset: import("vue-types").VueTypeValidableDef<number> & {
        default: number;
    };
    onChange: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    onClick: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
}, {
    configProvider: import("../config-provider").ConfigConsumerProps;
}, AnchorState, {}, {
    getCurrentActiveLink(offsetTop?: number, bounds?: number): any;
    handleScrollTo(link: string): void;
    setCurrentActiveLink(link: string): void;
    handleScroll(): void;
    updateInk(): void;
}, {
    methods: {
        setState(state: {}, callback: any): void;
        __emit(...args: any[]): void;
    };
}, import("vue").ComponentOptionsMixin, ("change" | "click")[], "change" | "click", import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<{
    onChange: (...args: any[]) => any;
    onClick: (...args: any[]) => any;
    prefixCls: string;
    offsetTop: number;
    affix: boolean;
    getContainer: (...args: any[]) => any;
    bounds: number;
    showInkInFixed: boolean;
    wrapperClass: string;
    getCurrentAnchor: (...args: any[]) => any;
    targetOffset: number;
} & {
    wrapperStyle?: import("vue").CSSProperties;
}>, {
    onChange: (...args: any[]) => any;
    onClick: (...args: any[]) => any;
    prefixCls: string;
    offsetTop: number;
    affix: boolean;
    getContainer: (...args: any[]) => any;
    bounds: number;
    showInkInFixed: boolean;
    wrapperClass: string;
    getCurrentAnchor: (...args: any[]) => any;
    targetOffset: number;
}>;
export default _default;
