"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _vue = require("vue");

var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));

var _propsUtil = require("../_util/props-util");

var _classNames3 = _interopRequireDefault(require("../_util/classNames"));

var _configProvider = require("../config-provider");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _isSlot(s) {
  return typeof s === 'function' || Object.prototype.toString.call(s) === '[object Object]' && !(0, _vue.isVNode)(s);
}

// eslint-disable-next-line @typescript-eslint/no-unused-vars
function noop() {}

var AnchorLinkProps = {
  prefixCls: _vueTypes.default.string,
  href: _vueTypes.default.string.def('#'),
  title: _vueTypes.default.VNodeChild,
  target: _vueTypes.default.string
};

var _default2 = (0, _vue.defineComponent)({
  name: 'AAnchorLink',
  props: AnchorLinkProps,
  setup: function setup() {
    return {
      antAnchor: (0, _vue.inject)('antAnchor', {
        registerLink: noop,
        unregisterLink: noop,
        scrollTo: noop,
        $data: {}
      }),
      antAnchorContext: (0, _vue.inject)('antAnchorContext', {}),
      configProvider: (0, _vue.inject)('configProvider', _configProvider.defaultConfigProvider)
    };
  },
  watch: {
    href: function href(val, oldVal) {
      var _this = this;

      (0, _vue.nextTick)(function () {
        _this.antAnchor.unregisterLink(oldVal);

        _this.antAnchor.registerLink(val);
      });
    }
  },
  mounted: function mounted() {
    this.antAnchor.registerLink(this.href);
  },
  beforeUnmount: function beforeUnmount() {
    this.antAnchor.unregisterLink(this.href);
  },
  methods: {
    handleClick: function handleClick(e) {
      this.antAnchor.scrollTo(this.href);
      var scrollTo = this.antAnchor.scrollTo;
      var _this$$props = this.$props,
          href = _this$$props.href,
          title = _this$$props.title;

      if (this.antAnchorContext.$emit) {
        this.antAnchorContext.$emit('click', e, {
          title: title,
          href: href
        });
      }

      scrollTo(href);
    }
  },
  render: function render() {
    var _a;

    var customizePrefixCls = this.prefixCls,
        href = this.href,
        $slots = this.$slots,
        target = this.target;
    var getPrefixCls = this.configProvider.getPrefixCls;
    var prefixCls = getPrefixCls('anchor', customizePrefixCls);
    var title = (0, _propsUtil.getComponent)(this, 'title');
    var active = this.antAnchor.$data.activeLink === href;
    var wrapperClassName = (0, _classNames3.default)("".concat(prefixCls, "-link"), _defineProperty({}, "".concat(prefixCls, "-link-active"), active));
    var titleClassName = (0, _classNames3.default)("".concat(prefixCls, "-link-title"), _defineProperty({}, "".concat(prefixCls, "-link-title-active"), active));
    return (0, _vue.createVNode)("div", {
      "class": wrapperClassName
    }, [(0, _vue.createVNode)("a", {
      "class": titleClassName,
      "href": href,
      "title": typeof title === 'string' ? title : '',
      "target": target,
      "onClick": this.handleClick
    }, _isSlot(title) ? title : {
      default: function _default() {
        return [title];
      }
    }), (_a = $slots.default) === null || _a === void 0 ? void 0 : _a.call($slots)]);
  }
});

exports.default = _default2;