import { PropType } from 'vue';
import { VueNode } from '../_util/type';
import moment from 'moment';
import { RadioChangeEvent } from '../radio/interface';
export interface RenderHeader {
    value: moment.Moment;
    onChange?: (value: moment.Moment) => void;
    type: string;
    onTypeChange: (type: string) => void;
}
export declare type HeaderRender = (headerRender: RenderHeader) => VueNode;
export declare const HeaderProps: {
    prefixCls: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    locale: import("vue-types").VueTypeValidableDef<any>;
    fullscreen: import("vue-types").VueTypeValidableDef<boolean>;
    yearSelectOffset: import("vue-types").VueTypeValidableDef<number> & {
        default: number;
    };
    yearSelectTotal: import("vue-types").VueTypeValidableDef<number> & {
        default: number;
    };
    type: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    value: {
        type: PropType<moment.Moment>;
    };
    validRange: {
        type: PropType<moment.Moment[]>;
    };
    headerRender: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    onValueChange: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    onTypeChange: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
};
declare const _default: import("vue").DefineComponent<{
    yearSelectOffset: import("vue-types").VueTypeValidableDef<number> & {
        default: number;
    } & {
        default: number;
    };
    yearSelectTotal: import("vue-types").VueTypeValidableDef<number> & {
        default: number;
    } & {
        default: number;
    };
    prefixCls: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    locale: import("vue-types").VueTypeValidableDef<any>;
    fullscreen: import("vue-types").VueTypeValidableDef<boolean>;
    type: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    value: {
        type: PropType<moment.Moment>;
    };
    validRange: {
        type: PropType<moment.Moment[]>;
    };
    headerRender: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    onValueChange: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    onTypeChange: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
}, {
    configProvider: import("../config-provider").ConfigConsumerProps;
    calendarHeaderNode: any;
}, unknown, {}, {
    getYearSelectElement(prefixCls: string, year: number): JSX.Element;
    getMonthSelectElement(prefixCls: string, month: number, months: string[]): JSX.Element;
    onYearChange(year: string): void;
    onMonthChange(month: string): void;
    onInternalTypeChange(e: RadioChangeEvent): void;
    triggerTypeChange(val: string): void;
    getMonthYearSelections(getPrefixCls: any): {
        yearReactNode: JSX.Element;
        monthReactNode: JSX.Element;
    };
    getTypeSwitch(): JSX.Element;
    triggerValueChange(...args: any[]): void;
    saveCalendarHeaderNode(node: HTMLElement): void;
    headerRenderCustom(headerRender: HeaderRender): VueNode;
}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, Record<string, any>, string, import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<{
    prefixCls: string;
    type: string;
    yearSelectOffset: number;
    yearSelectTotal: number;
    headerRender: (...args: any[]) => any;
    onValueChange: (...args: any[]) => any;
    onTypeChange: (...args: any[]) => any;
} & {
    locale?: any;
    value?: moment.Moment;
    fullscreen?: boolean;
    validRange?: moment.Moment[];
}>, {
    prefixCls: string;
    type: string;
    yearSelectOffset: number;
    yearSelectTotal: number;
    headerRender: (...args: any[]) => any;
    onValueChange: (...args: any[]) => any;
    onTypeChange: (...args: any[]) => any;
}>;
export default _default;
