"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _vue = require("vue");

var _propsUtil = require("../_util/props-util");

var _configProvider = require("../config-provider");

var _type = require("../_util/type");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _isSlot(s) {
  return typeof s === 'function' || Object.prototype.toString.call(s) === '[object Object]' && !(0, _vue.isVNode)(s);
}

var Divider = (0, _vue.defineComponent)({
  name: 'ADivider',
  props: {
    prefixCls: String,
    type: {
      type: String,
      default: 'horizontal'
    },
    dashed: {
      type: Boolean,
      default: false
    },
    orientation: {
      type: String,
      default: 'center'
    }
  },
  setup: function setup(props, _ref) {
    var slots = _ref.slots;

    var _inject = (0, _vue.inject)('configProvider', _configProvider.defaultConfigProvider),
        getPrefixCls = _inject.getPrefixCls;

    var prefixCls = (0, _vue.computed)(function () {
      return getPrefixCls('divider', props.prefixCls);
    });
    var classString = (0, _vue.computed)(function () {
      var _ref2;

      var type = props.type,
          dashed = props.dashed,
          orientation = props.orientation;
      var orientationPrefix = orientation.length > 0 ? '-' + orientation : orientation;
      var prefixClsRef = prefixCls.value;
      return _ref2 = {}, _defineProperty(_ref2, prefixClsRef, true), _defineProperty(_ref2, "".concat(prefixClsRef, "-").concat(type), true), _defineProperty(_ref2, "".concat(prefixClsRef, "-with-text").concat(orientationPrefix), slots.default), _defineProperty(_ref2, "".concat(prefixClsRef, "-dashed"), !!dashed), _ref2;
    });
    return function () {
      var _a;

      var children = (0, _propsUtil.flattenChildren)((_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots));
      return (0, _vue.createVNode)("div", {
        "class": classString.value,
        "role": "separator"
      }, [children.length ? (0, _vue.createVNode)("span", {
        "class": "".concat(prefixCls.value, "-inner-text")
      }, _isSlot(children) ? children : {
        default: function _default() {
          return [children];
        }
      }) : null]);
    };
  }
});

var _default2 = (0, _type.withInstall)(Divider);

exports.default = _default2;