"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _vue = require("vue");

var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));

var _propsUtil = require("../_util/props-util");

var _configProvider = require("../config-provider");

var _type = require("../_util/type");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _isSlot(s) {
  return typeof s === 'function' || Object.prototype.toString.call(s) === '[object Object]' && !(0, _vue.isVNode)(s);
}

var spaceSize = {
  small: 8,
  middle: 16,
  large: 24
};
var Space = (0, _vue.defineComponent)({
  name: 'ASpace',
  props: {
    prefixCls: _vueTypes.default.string,
    size: {
      type: [String, Number]
    },
    direction: _vueTypes.default.oneOf((0, _type.tuple)('horizontal', 'vertical')),
    align: _vueTypes.default.oneOf((0, _type.tuple)('start', 'end', 'center', 'baseline'))
  },
  setup: function setup(props, _ref) {
    var slots = _ref.slots;
    var configProvider = (0, _vue.inject)('configProvider', _configProvider.defaultConfigProvider);
    return function () {
      var _someSpaceClass;

      var _a;

      var align = props.align,
          _props$size = props.size,
          size = _props$size === void 0 ? 'small' : _props$size,
          _props$direction = props.direction,
          direction = _props$direction === void 0 ? 'horizontal' : _props$direction,
          customizePrefixCls = props.prefixCls;
      var getPrefixCls = configProvider.getPrefixCls;
      var prefixCls = getPrefixCls('space', customizePrefixCls);
      var items = (0, _propsUtil.filterEmpty)((_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots));
      var len = items.length;

      if (len === 0) {
        return null;
      }

      var mergedAlign = align === undefined && direction === 'horizontal' ? 'center' : align;
      var someSpaceClass = (_someSpaceClass = {}, _defineProperty(_someSpaceClass, prefixCls, true), _defineProperty(_someSpaceClass, "".concat(prefixCls, "-").concat(direction), true), _defineProperty(_someSpaceClass, "".concat(prefixCls, "-align-").concat(mergedAlign), mergedAlign), _someSpaceClass);
      var itemClassName = "".concat(prefixCls, "-item");
      var marginDirection = 'marginRight'; // directionConfig === 'rtl' ? 'marginLeft' : 'marginRight';

      return (0, _vue.createVNode)("div", {
        "class": someSpaceClass
      }, [items.map(function (child, i) {
        return (0, _vue.createVNode)("div", {
          "class": itemClassName,
          "key": "".concat(itemClassName, "-").concat(i),
          "style": i === len - 1 ? {} : _defineProperty({}, direction === 'vertical' ? 'marginBottom' : marginDirection, typeof size === 'string' ? "".concat(spaceSize[size], "px") : "".concat(size, "px"))
        }, _isSlot(child) ? child : {
          default: function _default() {
            return [child];
          }
        });
      })]);
    };
  }
});

var _default2 = (0, _type.withInstall)(Space);

exports.default = _default2;