"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _vue = require("vue");

var _padEnd = _interopRequireDefault(require("lodash-es/padEnd"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _isSlot(s) {
  return typeof s === 'function' || Object.prototype.toString.call(s) === '[object Object]' && !(0, _vue.isVNode)(s);
}

var StatisticNumber = function StatisticNumber(props) {
  var value = props.value,
      formatter = props.formatter,
      precision = props.precision,
      decimalSeparator = props.decimalSeparator,
      _props$groupSeparator = props.groupSeparator,
      groupSeparator = _props$groupSeparator === void 0 ? '' : _props$groupSeparator,
      prefixCls = props.prefixCls;
  var valueNode;

  if (typeof formatter === 'function') {
    // Customize formatter
    valueNode = formatter({
      value: value
    });
  } else {
    // Internal formatter
    var val = String(value);
    var cells = val.match(/^(-?)(\d*)(\.(\d+))?$/); // Process if illegal number

    if (!cells) {
      valueNode = val;
    } else {
      var negative = cells[1];

      var _int = cells[2] || '0';

      var decimal = cells[4] || '';
      _int = _int.replace(/\B(?=(\d{3})+(?!\d))/g, groupSeparator);

      if (typeof precision === 'number') {
        decimal = (0, _padEnd.default)(decimal, precision, '0').slice(0, precision);
      }

      if (decimal) {
        decimal = "".concat(decimalSeparator).concat(decimal);
      }

      valueNode = [(0, _vue.createVNode)("span", {
        "key": "int",
        "class": "".concat(prefixCls, "-content-value-int")
      }, [negative, _int]), decimal && (0, _vue.createVNode)("span", {
        "key": "decimal",
        "class": "".concat(prefixCls, "-content-value-decimal")
      }, _isSlot(decimal) ? decimal : {
        default: function _default() {
          return [decimal];
        }
      })];
    }
  }

  return (0, _vue.createVNode)("span", {
    "class": "".concat(prefixCls, "-content-value")
  }, _isSlot(valueNode) ? valueNode : {
    default: function _default() {
      return [valueNode];
    }
  });
};

StatisticNumber.displayName = 'StatisticNumber';
var _default2 = StatisticNumber;
exports.default = _default2;