"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _vue = require("vue");

var _LoadingOutlined = _interopRequireDefault(require("@ant-design/icons-vue/LoadingOutlined"));

var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));

var _propsUtil = _interopRequireWildcard(require("../_util/props-util"));

var _vcSwitch = _interopRequireDefault(require("../vc-switch"));

var _wave = _interopRequireDefault(require("../_util/wave"));

var _configProvider = require("../config-provider");

var _warning = _interopRequireDefault(require("../_util/warning"));

var _type = require("../_util/type");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var __rest = void 0 && (void 0).__rest || function (s, e) {
  var t = {};

  for (var p in s) {
    if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  }

  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};

function _isSlot(s) {
  return typeof s === 'function' || Object.prototype.toString.call(s) === '[object Object]' && !(0, _vue.isVNode)(s);
}

var Switch = (0, _vue.defineComponent)({
  name: 'ASwitch',
  __ANT_SWITCH: true,
  inheritAttrs: false,
  props: {
    prefixCls: _vueTypes.default.string,
    // size=default and size=large are the same
    size: _vueTypes.default.oneOf((0, _type.tuple)('small', 'default', 'large')),
    disabled: _vueTypes.default.looseBool,
    checkedChildren: _vueTypes.default.any,
    unCheckedChildren: _vueTypes.default.any,
    tabindex: _vueTypes.default.oneOfType([_vueTypes.default.string, _vueTypes.default.number]),
    checked: _vueTypes.default.looseBool,
    defaultChecked: _vueTypes.default.looseBool,
    autofocus: _vueTypes.default.looseBool,
    loading: _vueTypes.default.looseBool,
    onChange: _vueTypes.default.func,
    onClick: _vueTypes.default.func,
    'onUpdate:checked': _vueTypes.default.func
  },
  // emits: ['change', 'click', 'update:checked'],
  setup: function setup() {
    return {
      refSwitchNode: undefined,
      configProvider: (0, _vue.inject)('configProvider', _configProvider.defaultConfigProvider)
    };
  },
  created: function created() {
    (0, _warning.default)((0, _propsUtil.default)(this, 'checked') || !('value' in this.$attrs), 'Switch', '`value` is not validate prop, do you mean `checked`?');
  },
  methods: {
    focus: function focus() {
      var _a;

      (_a = this.refSwitchNode) === null || _a === void 0 ? void 0 : _a.focus();
    },
    blur: function blur() {
      var _a;

      (_a = this.refSwitchNode) === null || _a === void 0 ? void 0 : _a.blur();
    },
    saveRef: function saveRef(c) {
      this.refSwitchNode = c;
    }
  },
  render: function render() {
    var _slot;

    var _classes;

    var _a = (0, _propsUtil.getOptionProps)(this),
        customizePrefixCls = _a.prefixCls,
        size = _a.size,
        loading = _a.loading,
        disabled = _a.disabled,
        restProps = __rest(_a, ["prefixCls", "size", "loading", "disabled"]);

    var getPrefixCls = this.configProvider.getPrefixCls;
    var prefixCls = getPrefixCls('switch', customizePrefixCls);
    var $attrs = this.$attrs;
    var classes = (_classes = {}, _defineProperty(_classes, $attrs.class, $attrs.class), _defineProperty(_classes, "".concat(prefixCls, "-small"), size === 'small'), _defineProperty(_classes, "".concat(prefixCls, "-loading"), loading), _classes);
    var loadingIcon = loading ? (0, _vue.createVNode)(_LoadingOutlined.default, {
      "class": "".concat(prefixCls, "-loading-icon")
    }, null) : null;

    var switchProps = _extends(_extends(_extends({}, restProps), $attrs), {
      prefixCls: prefixCls,
      loadingIcon: loadingIcon,
      checkedChildren: (0, _propsUtil.getComponent)(this, 'checkedChildren'),
      unCheckedChildren: (0, _propsUtil.getComponent)(this, 'unCheckedChildren'),
      disabled: disabled || loading,
      class: classes,
      ref: this.saveRef
    });

    return (0, _vue.createVNode)(_wave.default, {
      "insertExtraNode": true
    }, _isSlot(_slot = (0, _vue.createVNode)(_vcSwitch.default, switchProps, null)) ? _slot : {
      default: function _default() {
        return [_slot];
      }
    });
  }
});

var _default2 = (0, _type.withInstall)(Switch);

exports.default = _default2;