"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _vue = require("vue");

var _DownOutlined = _interopRequireDefault(require("@ant-design/icons-vue/DownOutlined"));

var _checkbox = _interopRequireDefault(require("../checkbox"));

var _dropdown = _interopRequireDefault(require("../dropdown"));

var _menu = _interopRequireDefault(require("../menu"));

var _classNames2 = _interopRequireDefault(require("../_util/classNames"));

var _interface = require("./interface");

var _BaseMixin = _interopRequireDefault(require("../_util/BaseMixin"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _isSlot(s) {
  return typeof s === 'function' || Object.prototype.toString.call(s) === '[object Object]' && !(0, _vue.isVNode)(s);
}

function checkSelection(_ref) {
  var store = _ref.store,
      getCheckboxPropsByItem = _ref.getCheckboxPropsByItem,
      getRecordKey = _ref.getRecordKey,
      data = _ref.data,
      type = _ref.type,
      byDefaultChecked = _ref.byDefaultChecked;
  return byDefaultChecked ? data[type](function (item, i) {
    return getCheckboxPropsByItem(item, i).defaultChecked;
  }) : data[type](function (item, i) {
    return store.getState().selectedRowKeys.indexOf(getRecordKey(item, i)) >= 0;
  });
}

function getIndeterminateState(props) {
  var store = props.store,
      data = props.data;

  if (!data.length) {
    return false;
  }

  var someCheckedNotByDefaultChecked = checkSelection(_extends(_extends({}, props), {
    data: data,
    type: 'some',
    byDefaultChecked: false
  })) && !checkSelection(_extends(_extends({}, props), {
    data: data,
    type: 'every',
    byDefaultChecked: false
  }));
  var someCheckedByDefaultChecked = checkSelection(_extends(_extends({}, props), {
    data: data,
    type: 'some',
    byDefaultChecked: true
  })) && !checkSelection(_extends(_extends({}, props), {
    data: data,
    type: 'every',
    byDefaultChecked: true
  }));

  if (store.getState().selectionDirty) {
    return someCheckedNotByDefaultChecked;
  }

  return someCheckedNotByDefaultChecked || someCheckedByDefaultChecked;
}

function getCheckState(props) {
  var store = props.store,
      data = props.data;

  if (!data.length) {
    return false;
  }

  if (store.getState().selectionDirty) {
    return checkSelection(_extends(_extends({}, props), {
      data: data,
      type: 'every',
      byDefaultChecked: false
    }));
  }

  return checkSelection(_extends(_extends({}, props), {
    data: data,
    type: 'every',
    byDefaultChecked: false
  })) || checkSelection(_extends(_extends({}, props), {
    data: data,
    type: 'every',
    byDefaultChecked: true
  }));
}

var _default2 = (0, _vue.defineComponent)({
  name: 'SelectionCheckboxAll',
  mixins: [_BaseMixin.default],
  inheritAttrs: false,
  props: _interface.SelectionCheckboxAllProps,
  setup: function setup() {
    return {
      defaultSelections: [],
      unsubscribe: null
    };
  },
  data: function data() {
    var props = this.$props;
    return {
      checked: getCheckState(props),
      indeterminate: getIndeterminateState(props)
    };
  },
  watch: {
    propsSymbol: {
      handler: function handler() {
        this.setCheckState(this.$props);
      }
    }
  },
  created: function created() {
    var props = this.$props;
    this.defaultSelections = props.hideDefaultSelections ? [] : [{
      key: 'all',
      text: props.locale.selectAll
    }, {
      key: 'invert',
      text: props.locale.selectInvert
    }];
  },
  mounted: function mounted() {
    this.subscribe();
  },
  beforeUnmount: function beforeUnmount() {
    if (this.unsubscribe) {
      this.unsubscribe();
    }
  },
  methods: {
    checkSelection: function checkSelection(props, data, type, byDefaultChecked) {
      var _ref2 = props || this.$props,
          store = _ref2.store,
          getCheckboxPropsByItem = _ref2.getCheckboxPropsByItem,
          getRecordKey = _ref2.getRecordKey; // type should be 'every' | 'some'


      if (type === 'every' || type === 'some') {
        return byDefaultChecked ? data[type](function (item, i) {
          return getCheckboxPropsByItem(item, i).defaultChecked;
        }) : data[type](function (item, i) {
          return store.getState().selectedRowKeys.indexOf(getRecordKey(item, i)) >= 0;
        });
      }

      return false;
    },
    setCheckState: function setCheckState(props) {
      var checked = getCheckState(props);
      var indeterminate = getIndeterminateState(props);
      this.setState(function (prevState) {
        var newState = {};

        if (indeterminate !== prevState.indeterminate) {
          newState.indeterminate = indeterminate;
        }

        if (checked !== prevState.checked) {
          newState.checked = checked;
        }

        return newState;
      });
    },
    handleSelectAllChange: function handleSelectAllChange(e) {
      var checked = e.target.checked;
      this.$emit('select', checked ? 'all' : 'removeAll', 0, null);
    },
    subscribe: function subscribe() {
      var _this = this;

      var store = this.store;
      this.unsubscribe = store.subscribe(function () {
        _this.setCheckState(_this.$props);
      });
    },
    renderMenus: function renderMenus(selections) {
      var _this2 = this;

      return selections.map(function (selection, index) {
        var _slot;

        return (0, _vue.createVNode)(_menu.default.Item, {
          "key": selection.key || index
        }, _isSlot(_slot = (0, _vue.createVNode)("div", {
          "onClick": function onClick() {
            _this2.$emit('select', selection.key, index, selection.onSelect);
          }
        }, [selection.text])) ? _slot : {
          default: function _default() {
            return [_slot];
          }
        });
      });
    }
  },
  render: function render() {
    var disabled = this.disabled,
        prefixCls = this.prefixCls,
        selections = this.selections,
        getPopupContainer = this.getPopupContainer,
        checked = this.checked,
        indeterminate = this.indeterminate;
    var selectionPrefixCls = "".concat(prefixCls, "-selection");
    var customSelections = null;

    if (selections) {
      var _slot2, _slot3;

      var newSelections = Array.isArray(selections) ? this.defaultSelections.concat(selections) : this.defaultSelections;
      var menu = (0, _vue.createVNode)(_menu.default, {
        "class": "".concat(selectionPrefixCls, "-menu"),
        "selectedKeys": []
      }, _isSlot(_slot2 = this.renderMenus(newSelections)) ? _slot2 : {
        default: function _default() {
          return [_slot2];
        }
      });
      customSelections = newSelections.length > 0 ? (0, _vue.createVNode)(_dropdown.default, {
        "getPopupContainer": getPopupContainer,
        "overlay": menu
      }, _isSlot(_slot3 = (0, _vue.createVNode)("div", {
        "class": "".concat(selectionPrefixCls, "-down")
      }, [(0, _vue.createVNode)(_DownOutlined.default, null, null)])) ? _slot3 : {
        default: function _default() {
          return [_slot3];
        }
      }) : null;
    }

    return (0, _vue.createVNode)("div", {
      "class": selectionPrefixCls
    }, [(0, _vue.createVNode)(_checkbox.default, {
      "class": (0, _classNames2.default)(_defineProperty({}, "".concat(selectionPrefixCls, "-select-all-custom"), customSelections)),
      "checked": checked,
      "indeterminate": indeterminate,
      "disabled": disabled,
      "onChange": this.handleSelectAllChange
    }, null), customSelections]);
  }
});

exports.default = _default2;