"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createBodyRow;

var _vue = require("vue");

var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));

var _createStore = require("./createStore");

var _propsUtil = require("../_util/props-util");

var _omit = _interopRequireDefault(require("omit.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _isSlot(s) {
  return typeof s === 'function' || Object.prototype.toString.call(s) === '[object Object]' && !(0, _vue.isVNode)(s);
}

var BodyRowProps = {
  store: _createStore.Store,
  rowKey: _vueTypes.default.oneOfType([_vueTypes.default.string, _vueTypes.default.number]),
  prefixCls: _vueTypes.default.string
};

function createBodyRow() {
  var Component = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'tr';
  var BodyRow = (0, _vue.defineComponent)({
    name: 'BodyRow',
    inheritAttrs: false,
    props: BodyRowProps,
    setup: function setup() {
      return {
        unsubscribe: null
      };
    },
    data: function data() {
      var _this$store$getState = this.store.getState(),
          selectedRowKeys = _this$store$getState.selectedRowKeys;

      return {
        selected: selectedRowKeys.indexOf(this.rowKey) >= 0
      };
    },
    mounted: function mounted() {
      this.subscribe();
    },
    beforeUnmount: function beforeUnmount() {
      if (this.unsubscribe) {
        this.unsubscribe();
      }
    },
    methods: {
      subscribe: function subscribe() {
        var _this = this;

        var store = this.store,
            rowKey = this.rowKey;
        this.unsubscribe = store.subscribe(function () {
          var _this$store$getState2 = _this.store.getState(),
              selectedRowKeys = _this$store$getState2.selectedRowKeys;

          var selected = selectedRowKeys.indexOf(rowKey) >= 0;

          if (selected !== _this.selected) {
            _this.selected = selected;
          }
        });
      }
    },
    render: function render() {
      var _slot;

      var _className;

      var rowProps = (0, _omit.default)(_extends(_extends({}, this.$props), this.$attrs), ['prefixCls', 'rowKey', 'store', 'class']);
      var className = (_className = {}, _defineProperty(_className, "".concat(this.prefixCls, "-row-selected"), this.selected), _defineProperty(_className, this.$attrs.class, !!this.$attrs.class), _className);
      return (0, _vue.createVNode)(Component, _objectSpread({
        "class": className
      }, rowProps), _isSlot(_slot = (0, _propsUtil.getSlot)(this)) ? _slot : {
        default: function _default() {
          return [_slot];
        }
      });
    }
  });
  return BodyRow;
}