"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _vue = require("vue");

var _classNames2 = _interopRequireDefault(require("../_util/classNames"));

var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));

var _CloseOutlined = _interopRequireDefault(require("@ant-design/icons-vue/CloseOutlined"));

var _wave = _interopRequireDefault(require("../_util/wave"));

var _colors = require("../_util/colors");

var _configProvider = require("../config-provider");

var _CheckableTag = _interopRequireDefault(require("./CheckableTag"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _isSlot(s) {
  return typeof s === 'function' || Object.prototype.toString.call(s) === '[object Object]' && !(0, _vue.isVNode)(s);
}

var PresetColorRegex = new RegExp("^(".concat(_colors.PresetColorTypes.join('|'), ")(-inverse)?$"));
var PresetStatusColorRegex = new RegExp("^(".concat(_colors.PresetStatusColorTypes.join('|'), ")$"));
var tagProps = {
  prefixCls: _vueTypes.default.string,
  color: {
    type: String
  },
  closable: _vueTypes.default.looseBool.def(false),
  closeIcon: _vueTypes.default.VNodeChild,
  visible: _vueTypes.default.looseBool,
  onClose: {
    type: Function
  },
  icon: _vueTypes.default.VNodeChild
};
var Tag = (0, _vue.defineComponent)({
  name: 'ATag',
  emits: ['update:visible', 'close'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
        emit = _ref.emit,
        attrs = _ref.attrs;

    var _inject = (0, _vue.inject)('configProvider', _configProvider.defaultConfigProvider),
        getPrefixCls = _inject.getPrefixCls;

    var visible = (0, _vue.ref)(true);
    (0, _vue.watchEffect)(function () {
      if (props.visible !== undefined) {
        visible.value = props.visible;
      }
    });

    var handleCloseClick = function handleCloseClick(e) {
      e.stopPropagation();
      emit('update:visible', false);
      emit('close', e);

      if (e.defaultPrevented) {
        return;
      }

      if (props.visible === undefined) {
        visible.value = false;
      }
    };

    var isPresetColor = function isPresetColor() {
      var color = props.color;

      if (!color) {
        return false;
      }

      return PresetColorRegex.test(color) || PresetStatusColorRegex.test(color);
    };

    return function () {
      var _classNames;

      var _a, _b, _c;

      var customizePrefixCls = props.prefixCls,
          _props$icon = props.icon,
          icon = _props$icon === void 0 ? (_a = slots.icon) === null || _a === void 0 ? void 0 : _a.call(slots) : _props$icon,
          color = props.color,
          _props$closeIcon = props.closeIcon,
          closeIcon = _props$closeIcon === void 0 ? (_b = slots.closeIcon) === null || _b === void 0 ? void 0 : _b.call(slots) : _props$closeIcon,
          _props$closable = props.closable,
          closable = _props$closable === void 0 ? false : _props$closable;
      var presetColor = isPresetColor();
      var prefixCls = getPrefixCls('tag', customizePrefixCls);

      var renderCloseIcon = function renderCloseIcon() {
        if (closable) {
          return closeIcon ? (0, _vue.createVNode)("div", {
            "class": "".concat(prefixCls, "-close-icon"),
            "onClick": handleCloseClick
          }, _isSlot(closeIcon) ? closeIcon : {
            default: function _default() {
              return [closeIcon];
            }
          }) : (0, _vue.createVNode)(_CloseOutlined.default, {
            "class": "".concat(prefixCls, "-close-icon"),
            "onClick": handleCloseClick
          }, null);
        }

        return null;
      };

      var tagStyle = {
        backgroundColor: color && !isPresetColor() ? color : undefined
      };
      var tagClassName = (0, _classNames2.default)(prefixCls, (_classNames = {}, _defineProperty(_classNames, "".concat(prefixCls, "-").concat(color), presetColor), _defineProperty(_classNames, "".concat(prefixCls, "-has-color"), color && !presetColor), _defineProperty(_classNames, "".concat(prefixCls, "-hidden"), !visible.value), _classNames));
      var iconNode = icon || null;
      var children = (_c = slots.default) === null || _c === void 0 ? void 0 : _c.call(slots);
      var kids = iconNode ? (0, _vue.createVNode)(_vue.Fragment, null, [iconNode, (0, _vue.createVNode)("span", null, _isSlot(children) ? children : {
        default: function _default() {
          return [children];
        }
      })]) : children;
      var isNeedWave = ('onClick' in attrs);
      var tagNode = (0, _vue.createVNode)("span", {
        "class": tagClassName,
        "style": tagStyle
      }, [kids, renderCloseIcon()]);
      return isNeedWave ? (0, _vue.createVNode)(_wave.default, null, _isSlot(tagNode) ? tagNode : {
        default: function _default() {
          return [tagNode];
        }
      }) : tagNode;
    };
  }
});
Tag.props = tagProps;
Tag.CheckableTag = _CheckableTag.default;

Tag.install = function (app) {
  app.component(Tag.name, Tag);
  app.component(_CheckableTag.default.name, _CheckableTag.default);
  return app;
};

var _default2 = Tag;
exports.default = _default2;