"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.menuItemProps = exports.default = void 0;

var _vue = require("vue");

var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));

var _KeyCode = _interopRequireDefault(require("../_util/KeyCode"));

var _BaseMixin = _interopRequireDefault(require("../_util/BaseMixin"));

var _domScrollIntoView = _interopRequireDefault(require("dom-scroll-into-view"));

var _util = require("./util");

var _propsUtil = require("../_util/props-util");

var _InjectExtraProps = _interopRequireDefault(require("./InjectExtraProps"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var __rest = void 0 && (void 0).__rest || function (s, e) {
  var t = {};

  for (var p in s) {
    if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  }

  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};

var props = {
  attribute: _vueTypes.default.object,
  rootPrefixCls: _vueTypes.default.string,
  eventKey: _vueTypes.default.oneOfType([_vueTypes.default.string, _vueTypes.default.number]),
  active: _vueTypes.default.looseBool,
  selectedKeys: _vueTypes.default.array,
  disabled: _vueTypes.default.looseBool,
  title: _vueTypes.default.any,
  index: _vueTypes.default.number,
  inlineIndent: _vueTypes.default.number.def(24),
  level: _vueTypes.default.number.def(1),
  mode: _vueTypes.default.oneOf(['horizontal', 'vertical', 'vertical-left', 'vertical-right', 'inline']),
  multiple: _vueTypes.default.looseBool,
  value: _vueTypes.default.any,
  manualRef: _vueTypes.default.func.def(_util.noop),
  role: _vueTypes.default.any,
  subMenuKey: _vueTypes.default.string,
  itemIcon: _vueTypes.default.any,
  parentUniKeys: _vueTypes.default.array.def(function () {
    return [];
  }),
  parentUniKey: _vueTypes.default.string
};
exports.menuItemProps = props;
var indexGuid = 0;
var MenuItem = (0, _vue.defineComponent)({
  name: 'AMenuItem',
  mixins: [_BaseMixin.default],
  inheritAttrs: false,
  props: props,
  isMenuItem: true,
  setup: function setup(props) {
    var uniKey = "menu_item_".concat(++indexGuid);
    var store = (0, _vue.inject)('menuStore', function () {
      return {};
    });
    var isSelected = (0, _vue.computed)(function () {
      return store.selectedKeys.indexOf(props.eventKey) !== -1;
    });
    (0, _vue.onMounted)(function () {
      store.addChildrenInfo(uniKey, (0, _vue.computed)(function () {
        return {
          parentUniKeys: props.parentUniKeys,
          parentUniKey: props.parentUniKey,
          eventKey: props.eventKey,
          isSelected: isSelected.value,
          disabled: props.disabled
        };
      }));
    });
    (0, _vue.onBeforeUnmount)(function () {
      store.removeChildrenInfo(uniKey);
    });
    return {
      parentMenu: (0, _vue.inject)('parentMenu', undefined),
      isSelected: isSelected
    };
  },
  created: function created() {
    this.prevActive = this.active; // invoke customized ref to expose component to mixin

    this.callRef();
  },
  updated: function updated() {
    var _this = this;

    this.$nextTick(function () {
      var active = _this.active,
          parentMenu = _this.parentMenu,
          eventKey = _this.eventKey;

      if (!_this.prevActive && active && (!parentMenu || !parentMenu["scrolled-".concat(eventKey)])) {
        (0, _domScrollIntoView.default)((0, _propsUtil.findDOMNode)(_this.node), parentMenu.getEl(), {
          onlyScrollIfNeeded: true
        });
        parentMenu["scrolled-".concat(eventKey)] = true;
      } else if (parentMenu && parentMenu["scrolled-".concat(eventKey)]) {
        delete parentMenu["scrolled-".concat(eventKey)];
      }

      _this.prevActive = active;
    });
    this.callRef();
  },
  methods: {
    onKeyDown: function onKeyDown(e) {
      var keyCode = e.keyCode;

      if (keyCode === _KeyCode.default.ENTER) {
        this.onClick(e);
        return true;
      }
    },
    onMouseLeave: function onMouseLeave(e) {
      var eventKey = this.$props.eventKey;

      this.__emit('itemHover', {
        key: eventKey,
        hover: false
      });

      this.__emit('mouseleave', {
        key: eventKey,
        domEvent: e
      });
    },
    onMouseEnter: function onMouseEnter(e) {
      var eventKey = this.eventKey;

      this.__emit('itemHover', {
        key: eventKey,
        hover: true
      });

      this.__emit('mouseenter', {
        key: eventKey,
        domEvent: e
      });
    },
    onClick: function onClick(e) {
      var _this$$props = this.$props,
          eventKey = _this$$props.eventKey,
          multiple = _this$$props.multiple;
      var isSelected = this.isSelected;
      var info = {
        key: eventKey,
        keyPath: [eventKey],
        item: _extends(_extends({}, (0, _vue.toRaw)(this.$props)), {
          isSelected: isSelected
        }),
        domEvent: e
      };

      this.__emit('click', info);

      if (multiple) {
        if (isSelected) {
          this.__emit('deselect', info);
        } else {
          this.__emit('select', info);
        }
      } else if (!isSelected) {
        this.__emit('select', info);
      }
    },
    getPrefixCls: function getPrefixCls() {
      return "".concat(this.$props.rootPrefixCls, "-item");
    },
    getActiveClassName: function getActiveClassName() {
      return "".concat(this.getPrefixCls(), "-active");
    },
    getSelectedClassName: function getSelectedClassName() {
      return "".concat(this.getPrefixCls(), "-selected");
    },
    getDisabledClassName: function getDisabledClassName() {
      return "".concat(this.getPrefixCls(), "-disabled");
    },
    saveNode: function saveNode(node) {
      this.node = node;
    },
    callRef: function callRef() {
      if (this.manualRef) {
        this.manualRef(this);
      }
    }
  },
  render: function render() {
    var _className;

    var _a = _extends(_extends({}, this.$props), this.$attrs),
        cls = _a.class,
        style = _a.style,
        props = __rest(_a, ["class", "style"]);

    var className = (_className = {}, _defineProperty(_className, cls, !!cls), _defineProperty(_className, this.getPrefixCls(), true), _defineProperty(_className, this.getActiveClassName(), !props.disabled && this.active), _defineProperty(_className, this.getSelectedClassName(), this.isSelected), _defineProperty(_className, this.getDisabledClassName(), props.disabled), _className);

    var attrs = _extends(_extends({}, props.attribute), {
      title: props.title,
      role: props.role || 'menuitem',
      'aria-disabled': props.disabled
    });

    if (props.role === 'option') {
      // overwrite to option
      attrs = _extends(_extends({}, attrs), {
        role: 'option',
        'aria-selected': this.isSelected
      });
    } else if (props.role === null || props.role === 'none') {
      // sometimes we want to specify role inside <li/> element
      // <li><a role='menuitem'>Link</a></li> would be a good example
      // in this case the role on <li/> should be "none" to
      // remove the implied listitem role.
      // https://www.w3.org/TR/wai-aria-practices-1.1/examples/menubar/menubar-1/menubar-1.html
      attrs.role = 'none';
    } // In case that onClick/onMouseLeave/onMouseEnter is passed down from owner


    var mouseEvent = {
      onClick: props.disabled ? _util.noop : this.onClick,
      onMouseleave: props.disabled ? _util.noop : this.onMouseLeave,
      onMouseenter: props.disabled ? _util.noop : this.onMouseEnter
    };

    var styles = _extends({}, style || {});

    if (props.mode === 'inline') {
      styles.paddingLeft = "".concat(props.inlineIndent * props.level, "px");
    }

    _util.menuAllProps.forEach(function (key) {
      return delete props[key];
    });

    var liProps = _extends(_extends(_extends(_extends({}, props), attrs), mouseEvent), {
      ref: this.saveNode
    });

    return (0, _vue.createVNode)("li", _objectSpread(_objectSpread({}, liProps), {}, {
      "style": styles,
      "class": className
    }), [(0, _propsUtil.getSlot)(this), (0, _propsUtil.getComponent)(this, 'itemIcon', props)]);
  }
});

var _default = (0, _InjectExtraProps.default)(MenuItem);

exports.default = _default;