"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _vue = require("vue");

var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));

var _propsUtil = require("../_util/props-util");

var _util = require("./util");

var _classNames = _interopRequireDefault(require("../_util/classNames"));

var _FunctionProvider = require("./FunctionProvider");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var MenuItemGroup = {
  name: 'MenuItemGroup',
  inheritAttrs: false,
  setup: function setup() {
    return {
      injectExtraProps: (0, _vue.inject)(_FunctionProvider.injectExtraPropsKey, function () {
        return {};
      })
    };
  },
  props: {
    renderMenuItem: _vueTypes.default.func,
    index: _vueTypes.default.number,
    className: _vueTypes.default.string,
    subMenuKey: _vueTypes.default.string,
    rootPrefixCls: _vueTypes.default.string,
    disabled: _vueTypes.default.looseBool.def(true),
    title: _vueTypes.default.any
  },
  isMenuItemGroup: true,
  methods: {
    renderInnerMenuItem: function renderInnerMenuItem(item) {
      var _Object$assign = _extends(_extends({}, this.$props), this.injectExtraProps),
          renderMenuItem = _Object$assign.renderMenuItem,
          index = _Object$assign.index,
          subMenuKey = _Object$assign.subMenuKey;

      return renderMenuItem(item, index, subMenuKey);
    }
  },
  render: function render() {
    var props = _extends(_extends(_extends({}, this.$props), this.injectExtraProps), this.$attrs);

    var _props$class = props.class,
        cls = _props$class === void 0 ? '' : _props$class,
        rootPrefixCls = props.rootPrefixCls,
        title = props.title;
    var titleClassName = "".concat(rootPrefixCls, "-item-group-title");
    var listClassName = "".concat(rootPrefixCls, "-item-group-list");

    _util.menuAllProps.forEach(function (key) {
      return delete props[key];
    }); // Set onClick to null, to ignore propagated onClick event


    delete props.onClick;
    var children = (0, _propsUtil.getSlot)(this);
    return (0, _vue.createVNode)("li", _objectSpread(_objectSpread({}, props), {}, {
      "class": (0, _classNames.default)(cls, "".concat(rootPrefixCls, "-item-group"))
    }), [(0, _vue.createVNode)("div", {
      "class": titleClassName,
      "title": typeof title === 'string' ? title : undefined
    }, [(0, _propsUtil.getComponent)(this, 'title')]), (0, _vue.createVNode)("ul", {
      "class": listClassName
    }, [children && children.map(this.renderInnerMenuItem)])]);
  }
};

var _default = (0, _vue.defineComponent)(MenuItemGroup);

exports.default = _default;