"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _vue = require("vue");

var _vueTypes = _interopRequireDefault(require("../../_util/vue-types"));

var _classNames = _interopRequireDefault(require("../../_util/classNames"));

var _KeyCode = _interopRequireDefault(require("../../_util/KeyCode"));

var _propsUtil = require("../../_util/props-util");

var _BaseMixin = _interopRequireDefault(require("../../_util/BaseMixin"));

var _util = require("./util");

var _Star = _interopRequireDefault(require("./Star"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _isSlot(s) {
  return typeof s === 'function' || Object.prototype.toString.call(s) === '[object Object]' && !(0, _vue.isVNode)(s);
}

var rateProps = {
  disabled: _vueTypes.default.looseBool,
  value: _vueTypes.default.number,
  defaultValue: _vueTypes.default.number,
  count: _vueTypes.default.number,
  allowHalf: _vueTypes.default.looseBool,
  allowClear: _vueTypes.default.looseBool,
  prefixCls: _vueTypes.default.string,
  character: _vueTypes.default.any,
  characterRender: _vueTypes.default.func,
  tabindex: _vueTypes.default.number,
  autofocus: _vueTypes.default.looseBool
};

function noop() {}

var _default2 = (0, _vue.defineComponent)({
  name: 'Rate',
  mixins: [_BaseMixin.default],
  inheritAttrs: false,
  props: (0, _propsUtil.initDefaultProps)(rateProps, {
    defaultValue: 0,
    count: 5,
    allowHalf: false,
    allowClear: true,
    prefixCls: 'rc-rate',
    tabindex: 0,
    character: '★'
  }),
  data: function data() {
    var value = this.value;

    if (!(0, _propsUtil.hasProp)(this, 'value')) {
      value = this.defaultValue;
    }

    return {
      sValue: value,
      focused: false,
      cleanedValue: null,
      hoverValue: undefined
    };
  },
  watch: {
    value: function value(val) {
      this.setState({
        sValue: val
      });
    }
  },
  mounted: function mounted() {
    var _this = this;

    this.$nextTick(function () {
      if (_this.autofocus && !_this.disabled) {
        _this.focus();
      }
    });
  },
  methods: {
    onHover: function onHover(event, index) {
      var hoverValue = this.getStarValue(index, event.pageX);
      var cleanedValue = this.cleanedValue;

      if (hoverValue !== cleanedValue) {
        this.setState({
          hoverValue: hoverValue,
          cleanedValue: null
        });
      }

      this.__emit('hoverChange', hoverValue);
    },
    onMouseLeave: function onMouseLeave() {
      this.setState({
        hoverValue: undefined,
        cleanedValue: null
      });

      this.__emit('hoverChange', undefined);
    },
    onClick: function onClick(event, index) {
      var allowClear = this.allowClear,
          value = this.sValue;
      var newValue = this.getStarValue(index, event.pageX);
      var isReset = false;

      if (allowClear) {
        isReset = newValue === value;
      }

      this.onMouseLeave(true);
      this.changeValue(isReset ? 0 : newValue);
      this.setState({
        cleanedValue: isReset ? newValue : null
      });
    },
    onFocus: function onFocus() {
      this.setState({
        focused: true
      });

      this.__emit('focus');
    },
    onBlur: function onBlur() {
      this.setState({
        focused: false
      });

      this.__emit('blur');
    },
    onKeyDown: function onKeyDown(event) {
      var keyCode = event.keyCode;
      var count = this.count,
          allowHalf = this.allowHalf;
      var sValue = this.sValue;

      if (keyCode === _KeyCode.default.RIGHT && sValue < count) {
        if (allowHalf) {
          sValue += 0.5;
        } else {
          sValue += 1;
        }

        this.changeValue(sValue);
        event.preventDefault();
      } else if (keyCode === _KeyCode.default.LEFT && sValue > 0) {
        if (allowHalf) {
          sValue -= 0.5;
        } else {
          sValue -= 1;
        }

        this.changeValue(sValue);
        event.preventDefault();
      }

      this.__emit('keydown', event);
    },
    getStarDOM: function getStarDOM(index) {
      return (0, _propsUtil.findDOMNode)(this.$refs['stars' + index]);
    },
    getStarValue: function getStarValue(index, x) {
      var value = index + 1;

      if (this.allowHalf) {
        var starEle = this.getStarDOM(index);
        var leftDis = (0, _util.getOffsetLeft)(starEle);
        var width = starEle.clientWidth;

        if (x - leftDis < width / 2) {
          value -= 0.5;
        }
      }

      return value;
    },
    focus: function focus() {
      if (!this.disabled) {
        this.$refs.rateRef.focus();
      }
    },
    blur: function blur() {
      if (!this.disabled) {
        this.$refs.rateRef.blur();
      }
    },
    changeValue: function changeValue(value) {
      if (!(0, _propsUtil.hasProp)(this, 'value')) {
        this.setState({
          sValue: value
        });
      }

      this.__emit('update:value', value);

      this.__emit('change', value);
    }
  },
  render: function render() {
    var _getOptionProps = (0, _propsUtil.getOptionProps)(this),
        count = _getOptionProps.count,
        allowHalf = _getOptionProps.allowHalf,
        prefixCls = _getOptionProps.prefixCls,
        disabled = _getOptionProps.disabled,
        tabindex = _getOptionProps.tabindex;

    var sValue = this.sValue,
        hoverValue = this.hoverValue,
        focused = this.focused;
    var _this$$attrs = this.$attrs,
        className = _this$$attrs.class,
        style = _this$$attrs.style;
    var stars = [];
    var disabledClass = disabled ? "".concat(prefixCls, "-disabled") : '';
    var character = (0, _propsUtil.getComponent)(this, 'character');
    var characterRender = this.characterRender || this.$slots.characterRender;

    for (var index = 0; index < count; index++) {
      var starProps = {
        index: index,
        count: count,
        disabled: disabled,
        prefixCls: "".concat(prefixCls, "-star"),
        allowHalf: allowHalf,
        value: hoverValue === undefined ? sValue : hoverValue,
        character: character,
        characterRender: characterRender,
        focused: focused,
        onClick: this.onClick,
        onHover: this.onHover,
        key: index,
        ref: "stars".concat(index)
      };
      stars.push((0, _vue.createVNode)(_Star.default, starProps, null));
    }

    return (0, _vue.createVNode)("ul", {
      "class": (0, _classNames.default)(prefixCls, disabledClass, className),
      "style": style,
      "onMouseleave": disabled ? noop : this.onMouseLeave,
      "tabindex": disabled ? -1 : tabindex,
      "onFocus": disabled ? noop : this.onFocus,
      "onBlur": disabled ? noop : this.onBlur,
      "onKeydown": disabled ? noop : this.onKeyDown,
      "ref": "rateRef",
      "role": "radiogroup"
    }, _isSlot(stars) ? stars : {
      default: function _default() {
        return [stars];
      }
    });
  }
});

exports.default = _default2;