/**
 * To match accessibility requirement, we always provide an input in the component.
 * Other element will not set `tabIndex` to avoid `onBlur` sequence problem.
 * For focused select, we set `aria-live="polite"` to update the accessibility content.
 *
 * ref:
 * - keyboard: https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Roles/listbox_role#Keyboard_interactions
 *
 * New api:
 * - listHeight
 * - listItemHeight
 * - component
 *
 * Remove deprecated api:
 * - multiple
 * - tags
 * - combobox
 * - firstActiveValue
 * - dropdownMenuStyle
 * - openClassName (Not list in api)
 *
 * Update:
 * - `backfill` only support `combobox` mode
 * - `combobox` mode not support `labelInValue` since it's meaningless
 * - `getInputElement` only support `combobox` mode
 * - `onChange` return OptionData instead of ReactNode
 * - `filterOption` `onChange` `onSelect` accept OptionData instead of ReactNode
 * - `combobox` mode trigger `onChange` will get `undefined` if no `value` match in Option
 * - `combobox` mode not support `optionLabelProp`
 */
import { OptionsType as SelectOptionsType } from './interface';
import { SelectProps } from './generate';
import { DefaultValueType } from './interface/generator';
export declare type ExportedSelectProps<ValueType extends DefaultValueType = DefaultValueType> = SelectProps<SelectOptionsType, ValueType>;
declare const Select: import("vue").DefineComponent<Pick<ExportedSelectProps<DefaultValueType>, "style" | "class" | "onFocus" | "onBlur" | "onChange" | "onKeydown" | "onKeyup" | "onClick" | "onMousedown" | "onMouseenter" | "onMouseleave" | "onSelect" | "prefixCls" | "direction" | "open" | "disabled" | "mode" | "virtual" | "id" | "options" | "defaultActiveFirstOption" | "notFoundContent" | "menuItemSelectedIcon" | "searchValue" | "value" | "labelInValue" | "optionLabelProp" | "optionFilterProp" | "filterOption" | "autofocus" | "tabindex" | "removeIcon" | "maxTagCount" | "maxTagTextLength" | "maxTagPlaceholder" | "tokenSeparators" | "tagRender" | "choiceTransitionName" | "placeholder" | "showSearch" | "onInputKeyDown" | "backfill" | "onSearch" | "animation" | "transitionName" | "dropdownStyle" | "dropdownClassName" | "dropdownMatchSelectWidth" | "dropdownRender" | "getPopupContainer" | "dropdownAlign" | "showAction" | "defaultValue" | "inputValue" | "autoClearSearchValue" | "onClear" | "allowClear" | "clearIcon" | "showArrow" | "inputIcon" | "defaultOpen" | "listHeight" | "listItemHeight" | "loading" | "getInputElement" | "onPopupScroll" | "onDropdownVisibleChange" | "onDeselect" | "internalProps">, {}, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, import("vue").EmitsOptions, string, import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<{
    dropdownAlign: any;
} & {
    style?: import("vue").CSSProperties;
    class?: string;
    onFocus?: EventHandlerNonNull;
    onBlur?: EventHandlerNonNull;
    onChange?: (value: DefaultValueType, option: import("./interface").OptionData | import("./interface").OptionGroupData | SelectOptionsType) => void;
    onKeydown?: EventHandlerNonNull;
    onKeyup?: EventHandlerNonNull;
    onClick?: EventHandlerNonNull;
    onMousedown?: EventHandlerNonNull;
    onMouseenter?: EventHandlerNonNull;
    onMouseleave?: EventHandlerNonNull;
    onSelect?: (value: string | number | import("./interface/generator").LabelValueType, option: import("./interface").OptionData | import("./interface").OptionGroupData) => void;
    prefixCls?: string;
    direction?: string;
    open?: boolean;
    disabled?: boolean;
    mode?: import("./interface").Mode;
    virtual?: boolean;
    id?: string;
    options?: SelectOptionsType;
    defaultActiveFirstOption?: boolean;
    notFoundContent?: import("vue").VNodeChild;
    menuItemSelectedIcon?: import("./interface").RenderNode;
    searchValue?: string;
    value?: DefaultValueType;
    labelInValue?: boolean;
    optionLabelProp?: string;
    optionFilterProp?: string;
    filterOption?: boolean | import("./interface/generator").FilterFunc<import("./interface").OptionData | import("./interface").OptionGroupData>;
    autofocus?: boolean;
    tabindex?: number;
    removeIcon?: import("vue").VNodeChild;
    maxTagCount?: number;
    maxTagTextLength?: number;
    maxTagPlaceholder?: string | number | boolean | void | import("vue").VNode<import("vue").RendererNode, import("vue").RendererElement, {
        [key: string]: any;
    }> | import("vue").VNodeArrayChildren | ((omittedValues: import("./interface/generator").LabelValueType[]) => import("vue").VNodeChild);
    tokenSeparators?: string[];
    tagRender?: (props: import("./interface/generator").CustomTagProps) => import("vue").VNodeChild;
    choiceTransitionName?: string;
    placeholder?: import("vue").VNodeChild;
    showSearch?: boolean;
    onInputKeyDown?: EventHandlerNonNull;
    backfill?: boolean;
    onSearch?: (value: string) => void;
    animation?: string;
    transitionName?: string;
    dropdownStyle?: import("vue").CSSProperties;
    dropdownClassName?: string;
    dropdownMatchSelectWidth?: number | boolean;
    dropdownRender?: unknown;
    getPopupContainer?: import("./interface").RenderDOMFunc;
    showAction?: ("click" | "focus")[];
    defaultValue?: DefaultValueType;
    inputValue?: string;
    autoClearSearchValue?: boolean;
    onClear?: void;
    allowClear?: boolean;
    clearIcon?: import("vue").VNodeChild;
    showArrow?: boolean;
    inputIcon?: import("./interface").RenderNode;
    defaultOpen?: boolean;
    listHeight?: number;
    listItemHeight?: number;
    loading?: boolean;
    getInputElement?: unknown;
    onPopupScroll?: EventHandlerNonNull;
    onDropdownVisibleChange?: (open: boolean) => void;
    onDeselect?: (value: string | number | import("./interface/generator").LabelValueType, option: import("./interface").OptionData | import("./interface").OptionGroupData) => void;
    internalProps?: {
        mark?: string;
        onClear?: import("./interface/generator").OnClear;
        skipTriggerChange?: boolean;
        skipTriggerSelect?: boolean;
        onRawSelect?: (value: import("../_util/type").Key, option: import("./interface").OptionData | import("./interface").OptionGroupData, source: import("./interface/generator").SelectSource) => void;
        onRawDeselect?: (value: import("../_util/type").Key, option: import("./interface").OptionData | import("./interface").OptionGroupData, source: import("./interface/generator").SelectSource) => void;
    };
}>, {
    dropdownAlign: any;
}>;
export default Select;
