"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useSelectTriggerControl;

var _vue = require("vue");

function useSelectTriggerControl(refs, open, triggerOpen) {
  function onGlobalMouseDown(event) {
    var _a, _b, _c;

    var target = event.target;
    var elements = [(_a = refs[0]) === null || _a === void 0 ? void 0 : _a.value, (_c = (_b = refs[1]) === null || _b === void 0 ? void 0 : _b.value) === null || _c === void 0 ? void 0 : _c.getPopupElement()];

    if (open.value && elements.every(function (element) {
      return element && !element.contains(target) && element !== target;
    })) {
      // Should trigger close
      triggerOpen(false);
    }
  }

  (0, _vue.onMounted)(function () {
    window.addEventListener('mousedown', onGlobalMouseDown);
  });
  (0, _vue.onBeforeUnmount)(function () {
    window.removeEventListener('mousedown', onGlobalMouseDown);
  });
}