"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _vue = require("vue");

var _PropTypes = require("./PropTypes");

var _BaseMixin = _interopRequireDefault(require("../_util/BaseMixin"));

var _propsUtil = require("../_util/props-util");

var _omit = _interopRequireDefault(require("omit.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var __rest = void 0 && (void 0).__rest || function (s, e) {
  var t = {};

  for (var p in s) {
    if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  }

  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};

// function noop () {
// }
var _default = (0, _vue.defineComponent)({
  name: 'VcSwitch',
  mixins: [_BaseMixin.default],
  inheritAttrs: false,
  props: _extends(_extends({}, _PropTypes.switchPropTypes), {
    prefixCls: _PropTypes.switchPropTypes.prefixCls.def('rc-switch')
  }),
  data: function data() {
    var checked = false;

    if ((0, _propsUtil.hasProp)(this, 'checked')) {
      checked = !!this.checked;
    } else {
      checked = !!this.defaultChecked;
    }

    return {
      stateChecked: checked
    };
  },
  watch: {
    checked: function checked(val) {
      this.stateChecked = val;
    }
  },
  mounted: function mounted() {
    var _this = this;

    this.$nextTick(function () {
      var autofocus = _this.autofocus,
          disabled = _this.disabled;

      if (autofocus && !disabled) {
        _this.focus();
      }
    });
  },
  methods: {
    saveRef: function saveRef(c) {
      this.refSwitchNode = c;
    },
    setChecked: function setChecked(checked, e) {
      if (this.disabled) {
        return;
      }

      if (!(0, _propsUtil.hasProp)(this, 'checked')) {
        this.stateChecked = checked;
      }

      this.__emit('change', checked, e);

      this.__emit('update:checked', checked);
    },
    handleClick: function handleClick(e) {
      var checked = !this.stateChecked;
      this.setChecked(checked, e);

      this.__emit('click', checked, e);
    },
    handleKeyDown: function handleKeyDown(e) {
      if (e.keyCode === 37) {
        // Left
        this.setChecked(false, e);
      } else if (e.keyCode === 39) {
        // Right
        this.setChecked(true, e);
      }
    },
    handleMouseUp: function handleMouseUp(e) {
      var _a;

      (_a = this.refSwitchNode) === null || _a === void 0 ? void 0 : _a.blur();

      this.__emit('mouseup', e);
    },
    focus: function focus() {
      var _a;

      (_a = this.refSwitchNode) === null || _a === void 0 ? void 0 : _a.focus();
    },
    blur: function blur() {
      var _a;

      (_a = this.refSwitchNode) === null || _a === void 0 ? void 0 : _a.blur();
    }
  },
  render: function render() {
    var _switchClassName;

    var _a = (0, _propsUtil.getOptionProps)(this),
        prefixCls = _a.prefixCls,
        disabled = _a.disabled,
        loadingIcon = _a.loadingIcon,
        restProps = __rest(_a, ["prefixCls", "disabled", "loadingIcon"]);

    var checked = this.stateChecked;
    var $attrs = this.$attrs;
    var switchClassName = (_switchClassName = {}, _defineProperty(_switchClassName, $attrs.class, $attrs.class), _defineProperty(_switchClassName, prefixCls, true), _defineProperty(_switchClassName, "".concat(prefixCls, "-checked"), checked), _defineProperty(_switchClassName, "".concat(prefixCls, "-disabled"), disabled), _switchClassName);

    var spanProps = _extends(_extends(_extends({}, (0, _omit.default)(restProps, ['checkedChildren', 'unCheckedChildren', 'checked', 'autofocus', 'defaultChecked'])), $attrs), {
      onKeydown: this.handleKeyDown,
      onClick: this.handleClick,
      onMouseup: this.handleMouseUp,
      type: 'button',
      role: 'switch',
      'aria-checked': checked,
      disabled: disabled,
      class: switchClassName,
      ref: this.saveRef
    });

    return (0, _vue.createVNode)("button", spanProps, [loadingIcon, (0, _vue.createVNode)("span", {
      "class": "".concat(prefixCls, "-inner")
    }, [checked ? (0, _propsUtil.getComponent)(this, 'checkedChildren') : (0, _propsUtil.getComponent)(this, 'unCheckedChildren')])]);
  }
});

exports.default = _default;