"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _vue = require("vue");

var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));

var _propsUtil = require("../_util/props-util");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _isSlot(s) {
  return typeof s === 'function' || Object.prototype.toString.call(s) === '[object Object]' && !(0, _vue.isVNode)(s);
}

var _default2 = {
  name: 'LazyRenderBox',
  props: {
    visible: _vueTypes.default.looseBool,
    hiddenClassName: _vueTypes.default.string
  },
  render: function render() {
    var hiddenClassName = this.$props.hiddenClassName;
    var child = (0, _propsUtil.getSlot)(this);

    if (hiddenClassName || child && child.length > 1 || child && child[0] && child[0].type === _vue.Text) {
      // const cls = '';
      // if (!visible && hiddenClassName) {
      //   // cls += ` ${hiddenClassName}`
      // }
      return (0, _vue.createVNode)("div", null, _isSlot(child) ? child : {
        default: function _default() {
          return [child];
        }
      });
    }

    return child && child[0];
  }
};
exports.default = _default2;