import { createVNode as _createVNode } from "vue";

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import { tuple } from '../_util/type';
import { defineComponent, inject, nextTick } from 'vue';
import { defaultConfigProvider } from '../config-provider';
import { getComponent } from '../_util/props-util';
import PropTypes from '../_util/vue-types';
export default defineComponent({
  name: 'AAvatar',
  props: {
    prefixCls: PropTypes.string,
    shape: PropTypes.oneOf(tuple('circle', 'square')),
    size: {
      type: [Number, String],
      default: 'default'
    },
    src: PropTypes.string,

    /** Srcset of image avatar */
    srcset: PropTypes.string,

    /** @deprecated please use `srcset` instead `srcSet` */
    srcSet: PropTypes.string,
    icon: PropTypes.VNodeChild,
    alt: PropTypes.string,
    loadError: {
      type: Function
    }
  },
  setup: function setup() {
    return {
      configProvider: inject('configProvider', defaultConfigProvider)
    };
  },
  data: function data() {
    return {
      isImgExist: true,
      isMounted: false,
      scale: 1,
      lastChildrenWidth: undefined,
      lastNodeWidth: undefined
    };
  },
  watch: {
    src: function src() {
      var _this = this;

      nextTick(function () {
        _this.isImgExist = true;
        _this.scale = 1; // force uodate for position

        _this.$forceUpdate();
      });
    }
  },
  mounted: function mounted() {
    var _this2 = this;

    nextTick(function () {
      _this2.setScale();

      _this2.isMounted = true;
    });
  },
  updated: function updated() {
    var _this3 = this;

    nextTick(function () {
      _this3.setScale();
    });
  },
  methods: {
    setScale: function setScale() {
      if (!this.$refs.avatarChildren || !this.$refs.avatarNode) {
        return;
      }

      var childrenWidth = this.$refs.avatarChildren.offsetWidth; // offsetWidth avoid affecting be transform scale

      var nodeWidth = this.$refs.avatarNode.offsetWidth; // denominator is 0 is no meaning

      if (childrenWidth === 0 || nodeWidth === 0 || this.lastChildrenWidth === childrenWidth && this.lastNodeWidth === nodeWidth) {
        return;
      }

      this.lastChildrenWidth = childrenWidth;
      this.lastNodeWidth = nodeWidth; // add 4px gap for each side to get better performance

      this.scale = nodeWidth - 8 < childrenWidth ? (nodeWidth - 8) / childrenWidth : 1;
    },
    handleImgLoadError: function handleImgLoadError() {
      var loadError = this.$props.loadError;
      var errorFlag = loadError ? loadError() : undefined;

      if (errorFlag !== false) {
        this.isImgExist = false;
      }
    }
  },
  render: function render() {
    var _sizeCls, _extends3;

    var _a, _b;

    var _this$$props = this.$props,
        customizePrefixCls = _this$$props.prefixCls,
        shape = _this$$props.shape,
        size = _this$$props.size,
        src = _this$$props.src,
        alt = _this$$props.alt,
        srcset = _this$$props.srcset,
        srcSet = _this$$props.srcSet;
    var icon = getComponent(this, 'icon');
    var getPrefixCls = this.configProvider.getPrefixCls;
    var prefixCls = getPrefixCls('avatar', customizePrefixCls);
    var _this$$data = this.$data,
        isImgExist = _this$$data.isImgExist,
        scale = _this$$data.scale,
        isMounted = _this$$data.isMounted;
    var sizeCls = (_sizeCls = {}, _defineProperty(_sizeCls, "".concat(prefixCls, "-lg"), size === 'large'), _defineProperty(_sizeCls, "".concat(prefixCls, "-sm"), size === 'small'), _sizeCls);

    var classString = _extends(_extends(_defineProperty({}, prefixCls, true), sizeCls), (_extends3 = {}, _defineProperty(_extends3, "".concat(prefixCls, "-").concat(shape), shape), _defineProperty(_extends3, "".concat(prefixCls, "-image"), src && isImgExist), _defineProperty(_extends3, "".concat(prefixCls, "-icon"), icon), _extends3));

    var sizeStyle = typeof size === 'number' ? {
      width: "".concat(size, "px"),
      height: "".concat(size, "px"),
      lineHeight: "".concat(size, "px"),
      fontSize: icon ? "".concat(size / 2, "px") : '18px'
    } : {};
    var children = (_b = (_a = this.$slots).default) === null || _b === void 0 ? void 0 : _b.call(_a);

    if (src && isImgExist) {
      children = _createVNode("img", {
        "src": src,
        "srcset": srcset || srcSet,
        "onError": this.handleImgLoadError,
        "alt": alt
      }, null);
    } else if (icon) {
      children = icon;
    } else {
      var childrenNode = this.$refs.avatarChildren;

      if (childrenNode || scale !== 1) {
        var transformString = "scale(".concat(scale, ") translateX(-50%)");
        var childrenStyle = {
          msTransform: transformString,
          WebkitTransform: transformString,
          transform: transformString
        };
        var sizeChildrenStyle = typeof size === 'number' ? {
          lineHeight: "".concat(size, "px")
        } : {};

        var _children = function () {
          return children;
        }();

        children = _createVNode("span", {
          "class": "".concat(prefixCls, "-string"),
          "ref": "avatarChildren",
          "style": _extends(_extends({}, sizeChildrenStyle), childrenStyle)
        }, [children]);
      } else {
        var _childrenStyle = {};

        if (!isMounted) {
          _childrenStyle.opacity = 0;
        }

        var _children2 = function () {
          return children;
        }();

        children = _createVNode("span", {
          "class": "".concat(prefixCls, "-string"),
          "ref": "avatarChildren",
          "style": {
            opacity: 0
          }
        }, [children]);
      }
    }

    return _createVNode("span", {
      "ref": "avatarNode",
      "class": classString,
      "style": sizeStyle
    }, [children]);
  }
});