import { createVNode as _createVNode } from "vue";

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

import { inject, provide, reactive, defineComponent, ref, onMounted, onBeforeUnmount } from 'vue';
import classNames from '../_util/classNames';
import { tuple } from '../_util/type';
import PropTypes from '../_util/vue-types';
import { defaultConfigProvider } from '../config-provider';
import ResponsiveObserve, { responsiveArray } from '../_util/responsiveObserve';
var RowAligns = tuple('top', 'middle', 'bottom', 'stretch');
var RowJustify = tuple('start', 'end', 'center', 'space-around', 'space-between');
var ARow = defineComponent({
  name: 'ARow',
  setup: function setup(props, _ref) {
    var slots = _ref.slots;
    var rowContext = reactive({
      gutter: undefined
    });
    provide('rowContext', rowContext);
    var token;
    onMounted(function () {
      token = ResponsiveObserve.subscribe(function (screen) {
        var currentGutter = props.gutter || 0;

        if (!Array.isArray(currentGutter) && _typeof(currentGutter) === 'object' || Array.isArray(currentGutter) && (_typeof(currentGutter[0]) === 'object' || _typeof(currentGutter[1]) === 'object')) {
          screens.value = screen;
        }
      });
    });
    onBeforeUnmount(function () {
      ResponsiveObserve.unsubscribe(token);
    });
    var screens = ref({
      xs: true,
      sm: true,
      md: true,
      lg: true,
      xl: true,
      xxl: true
    });

    var _inject = inject('configProvider', defaultConfigProvider),
        getPrefixCls = _inject.getPrefixCls;

    var getGutter = function getGutter() {
      var results = [0, 0];
      var _props$gutter = props.gutter,
          gutter = _props$gutter === void 0 ? 0 : _props$gutter;
      var normalizedGutter = Array.isArray(gutter) ? gutter : [gutter, 0];
      normalizedGutter.forEach(function (g, index) {
        if (_typeof(g) === 'object') {
          for (var i = 0; i < responsiveArray.length; i++) {
            var breakpoint = responsiveArray[i];

            if (screens.value[breakpoint] && g[breakpoint] !== undefined) {
              results[index] = g[breakpoint];
              break;
            }
          }
        } else {
          results[index] = g || 0;
        }
      });
      return results;
    };

    return function () {
      var _classNames;

      var _a;

      var customizePrefixCls = props.prefixCls,
          justify = props.justify,
          align = props.align;
      var prefixCls = getPrefixCls('row', customizePrefixCls);
      var gutter = getGutter();
      var classes = classNames(prefixCls, (_classNames = {}, _defineProperty(_classNames, "".concat(prefixCls, "-").concat(justify), justify), _defineProperty(_classNames, "".concat(prefixCls, "-").concat(align), align), _classNames));

      var rowStyle = _extends(_extends({}, gutter[0] > 0 ? {
        marginLeft: "".concat(gutter[0] / -2, "px"),
        marginRight: "".concat(gutter[0] / -2, "px")
      } : {}), gutter[1] > 0 ? {
        marginTop: "".concat(gutter[1] / -2, "px"),
        marginBottom: "".concat(gutter[1] / -2, "px")
      } : {});

      rowContext.gutter = gutter;
      return _createVNode("div", {
        "class": classes,
        "style": rowStyle
      }, [(_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots)]);
    };
  }
});
ARow.props = {
  type: PropTypes.oneOf(['flex']),
  align: PropTypes.oneOf(RowAligns),
  justify: PropTypes.oneOf(RowJustify),
  prefixCls: PropTypes.string,
  gutter: PropTypes.oneOfType([PropTypes.object, PropTypes.number, PropTypes.array]).def(0)
};
export default ARow;