import { createVNode as _createVNode } from "vue";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var __rest = this && this.__rest || function (s, e) {
  var t = {};

  for (var p in s) {
    if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  }

  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};

import classNames from '../_util/classNames';
import { inject, provide, defineComponent, nextTick } from 'vue';
import PropTypes from '../_util/vue-types';
import { tuple } from '../_util/type';
import { getOptionProps, hasProp, getComponent, getSlot } from '../_util/props-util';
import initDefaultProps from '../_util/props-util/initDefaultProps';
import BaseMixin from '../_util/BaseMixin';
import isNumeric from '../_util/isNumeric';
import { defaultConfigProvider } from '../config-provider';
import BarsOutlined from '@ant-design/icons-vue/BarsOutlined';
import RightOutlined from '@ant-design/icons-vue/RightOutlined';
import LeftOutlined from '@ant-design/icons-vue/LeftOutlined';
import omit from 'omit.js';
var dimensionMaxMap = {
  xs: '479.98px',
  sm: '575.98px',
  md: '767.98px',
  lg: '991.98px',
  xl: '1199.98px',
  xxl: '1599.98px'
};
export var SiderProps = {
  prefixCls: PropTypes.string,
  collapsible: PropTypes.looseBool,
  collapsed: PropTypes.looseBool,
  defaultCollapsed: PropTypes.looseBool,
  reverseArrow: PropTypes.looseBool,
  zeroWidthTriggerStyle: PropTypes.style,
  trigger: PropTypes.VNodeChild,
  width: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
  collapsedWidth: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
  breakpoint: PropTypes.oneOf(tuple('xs', 'sm', 'md', 'lg', 'xl', 'xxl')),
  theme: PropTypes.oneOf(tuple('light', 'dark')).def('dark'),
  onBreakpoint: Function,
  onCollapse: Function
};

var generateId = function () {
  var i = 0;
  return function () {
    var prefix = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
    i += 1;
    return "".concat(prefix).concat(i);
  };
}();

export default defineComponent({
  name: 'ALayoutSider',
  mixins: [BaseMixin],
  inheritAttrs: false,
  __ANT_LAYOUT_SIDER: true,
  props: initDefaultProps(SiderProps, {
    collapsible: false,
    defaultCollapsed: false,
    reverseArrow: false,
    width: 200,
    collapsedWidth: 80
  }),
  emits: ['breakpoint', 'update:collapsed', 'collapse'],
  setup: function setup() {
    return {
      siderHook: inject('siderHook', {}),
      configProvider: inject('configProvider', defaultConfigProvider)
    };
  },
  data: function data() {
    var uniqueId = generateId('ant-sider-');
    var matchMedia;

    if (typeof window !== 'undefined') {
      matchMedia = window.matchMedia;
    }

    var props = getOptionProps(this);
    var mql;

    if (matchMedia && props.breakpoint && props.breakpoint in dimensionMaxMap) {
      mql = matchMedia("(max-width: ".concat(dimensionMaxMap[props.breakpoint], ")"));
    }

    var sCollapsed;

    if ('collapsed' in props) {
      sCollapsed = props.collapsed;
    } else {
      sCollapsed = props.defaultCollapsed;
    }

    return {
      sCollapsed: sCollapsed,
      below: false,
      belowShow: false,
      uniqueId: uniqueId,
      mql: mql
    };
  },
  watch: {
    collapsed: function collapsed(val) {
      this.setState({
        sCollapsed: val
      });
    }
  },
  created: function created() {
    provide('layoutSiderContext', this); // menu组件中使用
  },
  mounted: function mounted() {
    var _this = this;

    nextTick(function () {
      if (_this.mql) {
        _this.mql.addListener(_this.responsiveHandler);

        _this.responsiveHandler(_this.mql);
      }

      if (_this.siderHook.addSider) {
        _this.siderHook.addSider(_this.uniqueId);
      }
    });
  },
  beforeUnmount: function beforeUnmount() {
    if (this.mql) {
      this.mql.removeListener(this.responsiveHandler);
    }

    if (this.siderHook.removeSider) {
      this.siderHook.removeSider(this.uniqueId);
    }
  },
  methods: {
    responsiveHandler: function responsiveHandler(mql) {
      this.setState({
        below: mql.matches
      });
      this.$emit('breakpoint', mql.matches);

      if (this.sCollapsed !== mql.matches) {
        this.setCollapsed(mql.matches, 'responsive');
      }
    },
    setCollapsed: function setCollapsed(collapsed, type) {
      if (!hasProp(this, 'collapsed')) {
        this.setState({
          sCollapsed: collapsed
        });
      }

      this.$emit('update:collapsed', collapsed);
      this.$emit('collapse', collapsed, type);
    },
    toggle: function toggle() {
      var collapsed = !this.sCollapsed;
      this.setCollapsed(collapsed, 'clickTrigger');
    },
    belowShowChange: function belowShowChange() {
      this.setState({
        belowShow: !this.belowShow
      });
    }
  },
  render: function render() {
    var _classNames;

    var _a = _extends(_extends({}, getOptionProps(this)), this.$attrs),
        customizePrefixCls = _a.prefixCls,
        className = _a.class,
        theme = _a.theme,
        collapsible = _a.collapsible,
        reverseArrow = _a.reverseArrow,
        style = _a.style,
        width = _a.width,
        collapsedWidth = _a.collapsedWidth,
        zeroWidthTriggerStyle = _a.zeroWidthTriggerStyle,
        others = __rest(_a, ["prefixCls", "class", "theme", "collapsible", "reverseArrow", "style", "width", "collapsedWidth", "zeroWidthTriggerStyle"]);

    var getPrefixCls = this.configProvider.getPrefixCls;
    var prefixCls = getPrefixCls('layout-sider', customizePrefixCls);
    var divProps = omit(others, ['collapsed', 'defaultCollapsed', 'onCollapse', 'breakpoint', 'onBreakpoint', 'siderHook', 'zeroWidthTriggerStyle', 'trigger']);
    var trigger = getComponent(this, 'trigger');
    var rawWidth = this.sCollapsed ? collapsedWidth : width; // use "px" as fallback unit for width

    var siderWidth = isNumeric(rawWidth) ? "".concat(rawWidth, "px") : String(rawWidth); // special trigger when collapsedWidth == 0

    var zeroWidthTrigger = parseFloat(String(collapsedWidth || 0)) === 0 ? _createVNode("span", {
      "onClick": this.toggle,
      "class": "".concat(prefixCls, "-zero-width-trigger ").concat(prefixCls, "-zero-width-trigger-").concat(reverseArrow ? 'right' : 'left'),
      "style": zeroWidthTriggerStyle
    }, [_createVNode(BarsOutlined, null, null)]) : null;
    var iconObj = {
      expanded: reverseArrow ? _createVNode(RightOutlined, null, null) : _createVNode(LeftOutlined, null, null),
      collapsed: reverseArrow ? _createVNode(LeftOutlined, null, null) : _createVNode(RightOutlined, null, null)
    };
    var status = this.sCollapsed ? 'collapsed' : 'expanded';
    var defaultTrigger = iconObj[status];
    var triggerDom = trigger !== null ? zeroWidthTrigger || _createVNode("div", {
      "class": "".concat(prefixCls, "-trigger"),
      "onClick": this.toggle,
      "style": {
        width: siderWidth
      }
    }, [trigger || defaultTrigger]) : null;

    var divStyle = _extends(_extends({}, style), {
      flex: "0 0 ".concat(siderWidth),
      maxWidth: siderWidth,
      minWidth: siderWidth,
      width: siderWidth
    });

    var siderCls = classNames(className, prefixCls, "".concat(prefixCls, "-").concat(theme), (_classNames = {}, _defineProperty(_classNames, "".concat(prefixCls, "-collapsed"), !!this.sCollapsed), _defineProperty(_classNames, "".concat(prefixCls, "-has-trigger"), collapsible && trigger !== null && !zeroWidthTrigger), _defineProperty(_classNames, "".concat(prefixCls, "-below"), !!this.below), _defineProperty(_classNames, "".concat(prefixCls, "-zero-width"), parseFloat(siderWidth) === 0), _classNames));
    return _createVNode("aside", _objectSpread(_objectSpread({
      "class": siderCls
    }, divProps), {}, {
      "style": divStyle
    }), [_createVNode("div", {
      "class": "".concat(prefixCls, "-children")
    }, [getSlot(this)]), collapsible || this.below && zeroWidthTrigger ? triggerDom : null]);
  }
});