import { createVNode as _createVNode, resolveDirective as _resolveDirective } from "vue";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var __rest = this && this.__rest || function (s, e) {
  var t = {};

  for (var p in s) {
    if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  }

  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};

import { defineComponent, inject, provide, toRef } from 'vue';
import omit from 'omit.js';
import VcMenu, { Divider, ItemGroup } from '../vc-menu';
import SubMenu from './SubMenu';
import PropTypes from '../_util/vue-types';
import animation from '../_util/openAnimation';
import warning from '../_util/warning';
import Item from './MenuItem';
import { hasProp, getOptionProps } from '../_util/props-util';
import BaseMixin from '../_util/BaseMixin';
import commonPropsType from '../vc-menu/commonPropsType';
import { defaultConfigProvider } from '../config-provider';
import { tuple } from '../_util/type'; // import raf from '../_util/raf';

export var MenuMode = PropTypes.oneOf(['vertical', 'vertical-left', 'vertical-right', 'horizontal', 'inline']);
export var menuProps = _extends(_extends({}, commonPropsType), {
  theme: PropTypes.oneOf(tuple('light', 'dark')).def('light'),
  mode: MenuMode.def('vertical'),
  selectable: PropTypes.looseBool,
  selectedKeys: PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.string, PropTypes.number])),
  defaultSelectedKeys: PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.string, PropTypes.number])),
  openKeys: PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.string, PropTypes.number])),
  defaultOpenKeys: PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.string, PropTypes.number])),
  openAnimation: PropTypes.oneOfType([PropTypes.string, PropTypes.object]),
  openTransitionName: PropTypes.string,
  prefixCls: PropTypes.string,
  multiple: PropTypes.looseBool,
  inlineIndent: PropTypes.number.def(24),
  inlineCollapsed: PropTypes.looseBool,
  isRootMenu: PropTypes.looseBool.def(true),
  focusable: PropTypes.looseBool.def(false),
  onOpenChange: PropTypes.func,
  onSelect: PropTypes.func,
  onDeselect: PropTypes.func,
  onClick: PropTypes.func,
  onMouseenter: PropTypes.func,
  onSelectChange: PropTypes.func
});
var Menu = defineComponent({
  name: 'AMenu',
  mixins: [BaseMixin],
  inheritAttrs: false,
  props: menuProps,
  Divider: _extends(_extends({}, Divider), {
    name: 'AMenuDivider'
  }),
  Item: _extends(_extends({}, Item), {
    name: 'AMenuItem'
  }),
  SubMenu: _extends(_extends({}, SubMenu), {
    name: 'ASubMenu'
  }),
  ItemGroup: _extends(_extends({}, ItemGroup), {
    name: 'AMenuItemGroup'
  }),
  emits: ['update:selectedKeys', 'update:openKeys', 'mouseenter', 'openChange', 'click', 'selectChange', 'select', 'deselect'],
  setup: function setup() {
    var layoutSiderContext = inject('layoutSiderContext', {});
    var layoutSiderCollapsed = toRef(layoutSiderContext, 'sCollapsed');
    return {
      configProvider: inject('configProvider', defaultConfigProvider),
      layoutSiderContext: layoutSiderContext,
      layoutSiderCollapsed: layoutSiderCollapsed,
      propsUpdating: false,
      switchingModeFromInline: false,
      leaveAnimationExecutedWhenInlineCollapsed: false,
      inlineOpenKeys: []
    };
  },
  data: function data() {
    var props = getOptionProps(this);
    warning(!('inlineCollapsed' in props && props.mode !== 'inline'), 'Menu', "`inlineCollapsed` should only be used when Menu's `mode` is inline.");
    var sOpenKeys;

    if ('openKeys' in props) {
      sOpenKeys = props.openKeys;
    } else if ('defaultOpenKeys' in props) {
      sOpenKeys = props.defaultOpenKeys;
    }

    return {
      sOpenKeys: sOpenKeys
    };
  },
  // beforeUnmount() {
  //   raf.cancel(this.mountRafId);
  // },
  watch: {
    mode: function mode(val, oldVal) {
      if (oldVal === 'inline' && val !== 'inline') {
        this.switchingModeFromInline = true;
      }
    },
    openKeys: function openKeys(val) {
      this.setState({
        sOpenKeys: val
      });
    },
    inlineCollapsed: function inlineCollapsed(val) {
      this.collapsedChange(val);
    },
    layoutSiderCollapsed: function layoutSiderCollapsed(val) {
      this.collapsedChange(val);
    }
  },
  created: function created() {
    provide('getInlineCollapsed', this.getInlineCollapsed);
    provide('menuPropsContext', this.$props);
  },
  updated: function updated() {
    this.propsUpdating = false;
  },
  methods: {
    collapsedChange: function collapsedChange(val) {
      if (this.propsUpdating) {
        return;
      }

      this.propsUpdating = true;

      if (!hasProp(this, 'openKeys')) {
        if (val) {
          this.switchingModeFromInline = true;
          this.inlineOpenKeys = this.sOpenKeys;
          this.setState({
            sOpenKeys: []
          });
        } else {
          this.setState({
            sOpenKeys: this.inlineOpenKeys
          });
          this.inlineOpenKeys = [];
        }
      } else if (val) {
        // 缩起时，openKeys置为空的动画会闪动，react可以通过是否传递openKeys避免闪动，vue不是很方便动态传递openKeys
        this.switchingModeFromInline = true;
      }
    },
    restoreModeVerticalFromInline: function restoreModeVerticalFromInline() {
      if (this.switchingModeFromInline) {
        this.switchingModeFromInline = false;
        this.$forceUpdate();
      }
    },
    // Restore vertical mode when menu is collapsed responsively when mounted
    // https://github.com/ant-design/ant-design/issues/13104
    // TODO: not a perfect solution, looking a new way to avoid setting switchingModeFromInline in this situation
    handleMouseEnter: function handleMouseEnter(e) {
      this.restoreModeVerticalFromInline();
      this.$emit('mouseenter', e);
    },
    handleTransitionEnd: function handleTransitionEnd(e) {
      // when inlineCollapsed menu width animation finished
      // https://github.com/ant-design/ant-design/issues/12864
      var widthCollapsed = e.propertyName === 'width' && e.target === e.currentTarget; // Fix SVGElement e.target.className.indexOf is not a function
      // https://github.com/ant-design/ant-design/issues/15699

      var className = e.target.className; // SVGAnimatedString.animVal should be identical to SVGAnimatedString.baseVal, unless during an animation.

      var classNameValue = Object.prototype.toString.call(className) === '[object SVGAnimatedString]' ? className.animVal : className; // Fix for <Menu style={{ width: '100%' }} />, the width transition won't trigger when menu is collapsed
      // https://github.com/ant-design/ant-design-pro/issues/2783

      var iconScaled = e.propertyName === 'font-size' && classNameValue.indexOf('anticon') >= 0;

      if (widthCollapsed || iconScaled) {
        this.restoreModeVerticalFromInline();
      }
    },
    handleClick: function handleClick(e) {
      this.handleOpenChange([]);
      this.$emit('click', e);
    },
    handleSelect: function handleSelect(info) {
      this.$emit('update:selectedKeys', info.selectedKeys);
      this.$emit('select', info);
      this.$emit('selectChange', info.selectedKeys);
    },
    handleDeselect: function handleDeselect(info) {
      this.$emit('update:selectedKeys', info.selectedKeys);
      this.$emit('deselect', info);
      this.$emit('selectChange', info.selectedKeys);
    },
    handleOpenChange: function handleOpenChange(openKeys) {
      this.setOpenKeys(openKeys);
      this.$emit('update:openKeys', openKeys);
      this.$emit('openChange', openKeys);
    },
    setOpenKeys: function setOpenKeys(openKeys) {
      if (!hasProp(this, 'openKeys')) {
        this.setState({
          sOpenKeys: openKeys
        });
      }
    },
    getRealMenuMode: function getRealMenuMode() {
      var inlineCollapsed = this.getInlineCollapsed();

      if (this.switchingModeFromInline && inlineCollapsed) {
        return 'inline';
      }

      var mode = this.$props.mode;
      return inlineCollapsed ? 'vertical' : mode;
    },
    getInlineCollapsed: function getInlineCollapsed() {
      var inlineCollapsed = this.$props.inlineCollapsed;

      if (this.layoutSiderContext.sCollapsed !== undefined) {
        return this.layoutSiderContext.sCollapsed;
      }

      return inlineCollapsed;
    },
    getMenuOpenAnimation: function getMenuOpenAnimation(menuMode) {
      var _this$$props = this.$props,
          openAnimation = _this$$props.openAnimation,
          openTransitionName = _this$$props.openTransitionName;
      var menuOpenAnimation = openAnimation || openTransitionName;

      if (openAnimation === undefined && openTransitionName === undefined) {
        if (menuMode === 'horizontal') {
          menuOpenAnimation = 'slide-up';
        } else if (menuMode === 'inline') {
          menuOpenAnimation = animation;
        } else {
          // When mode switch from inline
          // submenu should hide without animation
          if (this.switchingModeFromInline) {
            menuOpenAnimation = '';
            this.switchingModeFromInline = false;
          } else {
            menuOpenAnimation = 'zoom-big';
          }
        }
      }

      return menuOpenAnimation;
    }
  },
  render: function render() {
    var _menuClassName,
        _this = this;

    var layoutSiderContext = this.layoutSiderContext;
    var collapsedWidth = layoutSiderContext.collapsedWidth;
    var getContextPopupContainer = this.configProvider.getPopupContainer;
    var props = getOptionProps(this);
    var customizePrefixCls = props.prefixCls,
        theme = props.theme,
        getPopupContainer = props.getPopupContainer;
    var getPrefixCls = this.configProvider.getPrefixCls;
    var prefixCls = getPrefixCls('menu', customizePrefixCls);
    var menuMode = this.getRealMenuMode();
    var menuOpenAnimation = this.getMenuOpenAnimation(menuMode);

    var _a = this.$attrs,
        className = _a.class,
        otherAttrs = __rest(_a, ["class"]);

    var menuClassName = (_menuClassName = {}, _defineProperty(_menuClassName, className, className), _defineProperty(_menuClassName, "".concat(prefixCls, "-").concat(theme), true), _defineProperty(_menuClassName, "".concat(prefixCls, "-inline-collapsed"), this.getInlineCollapsed()), _menuClassName);

    var menuProps = _extends(_extends(_extends(_extends({}, omit(props, ['inlineCollapsed', 'onUpdate:selectedKeys', 'onUpdate:openKeys', 'onSelectChange'])), {
      getPopupContainer: getPopupContainer || getContextPopupContainer,
      openKeys: this.sOpenKeys,
      mode: menuMode,
      prefixCls: prefixCls
    }), otherAttrs), {
      onSelect: this.handleSelect,
      onDeselect: this.handleDeselect,
      onOpenChange: this.handleOpenChange,
      onMouseenter: this.handleMouseEnter,
      onTransitionend: this.handleTransitionEnd
    });

    if (!hasProp(this, 'selectedKeys')) {
      delete menuProps.selectedKeys;
    }

    if (menuMode !== 'inline') {
      // closing vertical popup submenu after click it
      menuProps.onClick = this.handleClick;
      menuProps.openTransitionName = menuOpenAnimation;
    } else {
      menuProps.onClick = function (e) {
        _this.$emit('click', e);
      };

      menuProps.openAnimation = menuOpenAnimation;
    } // https://github.com/ant-design/ant-design/issues/8587


    var hideMenu = this.getInlineCollapsed() && (collapsedWidth === 0 || collapsedWidth === '0' || collapsedWidth === '0px');

    if (hideMenu) {
      menuProps.openKeys = [];
    }

    return _createVNode(VcMenu, _objectSpread(_objectSpread({}, menuProps), {}, {
      "class": menuClassName
    }), this.$slots);
  }
});
/* istanbul ignore next */

Menu.install = function (app) {
  app.component(Menu.name, Menu);
  app.component(Menu.Item.name, Menu.Item);
  app.component(Menu.SubMenu.name, Menu.SubMenu);
  app.component(Menu.Divider.name, Menu.Divider);
  app.component(Menu.ItemGroup.name, Menu.ItemGroup);
  return app;
};

export default Menu;