import { VNode } from 'vue';
import { CheckEvent, ExpendEvent, SelectEvent } from './Tree';
export interface DirectoryTreeState {
    _expandedKeys?: (string | number)[];
    _selectedKeys?: (string | number)[];
}
declare const _default: import("vue").DefineComponent<{
    expandAction: import("vue-types").VueTypeDef<string | boolean>;
    showLine: import("vue-types").VueTypeValidableDef<boolean>;
    multiple: import("vue-types").VueTypeValidableDef<boolean>;
    autoExpandParent: import("vue-types").VueTypeValidableDef<boolean>;
    checkStrictly: import("vue-types").VueTypeValidableDef<boolean>;
    checkable: import("vue-types").VueTypeValidableDef<boolean>;
    disabled: import("vue-types").VueTypeValidableDef<boolean>;
    defaultExpandAll: import("vue-types").VueTypeValidableDef<boolean>;
    defaultExpandParent: import("vue-types").VueTypeValidableDef<boolean>;
    defaultExpandedKeys: import("vue-types").VueTypeDef<(string | number)[]>;
    expandedKeys: import("vue-types").VueTypeDef<(string | number)[]>;
    checkedKeys: import("vue-types").VueTypeDef<(string | number)[] | {
        checked: (string | number)[] | (() => (string | number)[]);
        halfChecked: (string | number)[] | (() => (string | number)[]);
    }>;
    defaultCheckedKeys: import("vue-types").VueTypeDef<(string | number)[]>;
    selectedKeys: import("vue-types").VueTypeDef<(string | number)[]>;
    defaultSelectedKeys: import("vue-types").VueTypeDef<(string | number)[]>;
    selectable: import("vue-types").VueTypeValidableDef<boolean>;
    filterAntTreeNode: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    loadData: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    loadedKeys: import("vue-types").VueTypeDef<(string | number)[]>;
    draggable: import("vue-types").VueTypeValidableDef<boolean>;
    showIcon: import("vue-types").VueTypeValidableDef<boolean>;
    icon: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    switcherIcon: import("vue-types").VueTypeValidableDef<any>;
    prefixCls: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    filterTreeNode: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    openAnimation: import("vue-types").VueTypeValidableDef<any>;
    treeData: {
        type: import("vue").PropType<import("./Tree").TreeDataItem[]>;
    };
    replaceFields: import("vue-types").VueTypeValidableDef<{
        [key: string]: any;
    }> & {
        default: () => {
            [key: string]: any;
        };
    };
    blockNode: import("vue-types").VueTypeValidableDef<boolean>;
    onExpand: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    onCheck: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    onSelect: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    onClick: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    onDoubleclick: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    onDblclick: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    'onUpdate:selectedKeys': import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    'onUpdate:checkedKeys': import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    'onUpdate:expandedKeys': import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
}, {
    children: any;
    onDebounceExpand: any;
    tree: any;
    lastSelectedKey: string;
    cachedSelectedKeys: any[];
    configProvider: import("../config-provider").ConfigConsumerProps;
}, {
    _expandedKeys: any[] | (string | number)[];
    _selectedKeys: any[] | (string | number)[];
}, {}, {
    handleExpand(expandedKeys: (string | number)[], info: ExpendEvent): any;
    handleClick(event: MouseEvent, node: VNode): void;
    handleDoubleClick(event: MouseEvent, node: VNode): void;
    hanldeSelect(keys: (string | number)[], event: SelectEvent): void;
    setTreeRef(node: VNode): void;
    expandFolderNode(event: MouseEvent, node: {
        isLeaf: boolean;
    } & VNode): void;
    setUncontrolledState(state: unknown): void;
    handleCheck(checkedObj: (string | number)[], eventObj: CheckEvent): void;
}, {
    methods: {
        setState(state: {}, callback: any): void;
        __emit(...args: any[]): void;
    };
}, import("vue").ComponentOptionsMixin, Record<string, any>, string, import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<{
    icon: (...args: any[]) => any;
    onClick: (...args: any[]) => any;
    onDblclick: (...args: any[]) => any;
    onSelect: (...args: any[]) => any;
    prefixCls: string;
    onExpand: (...args: any[]) => any;
    "onUpdate:selectedKeys": (...args: any[]) => any;
    loadData: (...args: any[]) => any;
    filterTreeNode: (...args: any[]) => any;
    replaceFields: {
        [key: string]: any;
    };
    filterAntTreeNode: (...args: any[]) => any;
    onCheck: (...args: any[]) => any;
    onDoubleclick: (...args: any[]) => any;
    "onUpdate:checkedKeys": (...args: any[]) => any;
    "onUpdate:expandedKeys": (...args: any[]) => any;
} & {
    multiple?: boolean;
    disabled?: boolean;
    showIcon?: boolean;
    draggable?: boolean;
    selectable?: boolean;
    openAnimation?: any;
    selectedKeys?: (string | number)[];
    defaultSelectedKeys?: (string | number)[];
    treeData?: import("./Tree").TreeDataItem[];
    switcherIcon?: any;
    expandedKeys?: (string | number)[];
    autoExpandParent?: boolean;
    checkedKeys?: (string | number)[] | {
        checked: (string | number)[] | (() => (string | number)[]);
        halfChecked: (string | number)[] | (() => (string | number)[]);
    };
    loadedKeys?: (string | number)[];
    checkable?: boolean;
    blockNode?: boolean;
    showLine?: boolean;
    checkStrictly?: boolean;
    defaultExpandAll?: boolean;
    defaultExpandParent?: boolean;
    defaultExpandedKeys?: (string | number)[];
    defaultCheckedKeys?: (string | number)[];
    expandAction?: string | boolean;
}>, {
    icon: (...args: any[]) => any;
    onClick: (...args: any[]) => any;
    onDblclick: (...args: any[]) => any;
    onSelect: (...args: any[]) => any;
    prefixCls: string;
    onExpand: (...args: any[]) => any;
    "onUpdate:selectedKeys": (...args: any[]) => any;
    loadData: (...args: any[]) => any;
    filterTreeNode: (...args: any[]) => any;
    replaceFields: {
        [key: string]: any;
    };
    filterAntTreeNode: (...args: any[]) => any;
    onCheck: (...args: any[]) => any;
    onDoubleclick: (...args: any[]) => any;
    "onUpdate:checkedKeys": (...args: any[]) => any;
    "onUpdate:expandedKeys": (...args: any[]) => any;
}>;
export default _default;
