import { VNode, PropType, CSSProperties } from 'vue';
export interface TreeDataItem {
    key?: string | number;
    title?: string;
    isLeaf?: boolean;
    selectable?: boolean;
    children?: TreeDataItem[];
    disableCheckbox?: boolean;
    disabled?: boolean;
    class?: string;
    style?: CSSProperties;
    checkable?: boolean;
    icon?: VNode;
    slots?: Record<string, string>;
    switcherIcon?: VNode;
    [key: string]: any;
}
interface DefaultEvent {
    nativeEvent: MouseEvent;
    node: Record<string, any>;
}
export interface CheckEvent extends DefaultEvent {
    checked: boolean;
    checkedNodes: Array<Record<string, any>>;
    checkedNodesPositions: {
        node: Record<string, any>;
        pos: string | number;
    }[];
    event: string;
    halfCheckedKeys: (string | number)[];
}
export interface ExpendEvent extends DefaultEvent {
    expanded: boolean;
}
export interface SelectEvent extends DefaultEvent {
    event: string;
    selected: boolean;
    selectedNodes: Array<Record<string, any>>;
}
export interface TreeDragEvent {
    event: DragEvent;
    expandedKeys: (string | number)[];
    node: Record<string, any>;
}
export interface DropEvent {
    dragNode: Record<string, any>;
    dragNodesKeys: (string | number)[];
    dropPosition: number;
    dropToGap: boolean;
    event: DragEvent;
    node: Record<string, any>;
}
declare function TreeProps(): {
    showLine: import("vue-types").VueTypeValidableDef<boolean>;
    /** 是否支持多选 */
    multiple: import("vue-types").VueTypeValidableDef<boolean>;
    /** 是否自动展开父节点 */
    autoExpandParent: import("vue-types").VueTypeValidableDef<boolean>;
    /** checkable状态下节点选择完全受控（父子节点选中状态不再关联）*/
    checkStrictly: import("vue-types").VueTypeValidableDef<boolean>;
    /** 是否支持选中 */
    checkable: import("vue-types").VueTypeValidableDef<boolean>;
    /** 是否禁用树 */
    disabled: import("vue-types").VueTypeValidableDef<boolean>;
    /** 默认展开所有树节点 */
    defaultExpandAll: import("vue-types").VueTypeValidableDef<boolean>;
    /** 默认展开对应树节点 */
    defaultExpandParent: import("vue-types").VueTypeValidableDef<boolean>;
    /** 默认展开指定的树节点 */
    defaultExpandedKeys: import("vue-types").VueTypeDef<(string | number)[]>;
    /** （受控）展开指定的树节点 */
    expandedKeys: import("vue-types").VueTypeDef<(string | number)[]>;
    /** （受控）选中复选框的树节点 */
    checkedKeys: import("vue-types").VueTypeDef<(string | number)[] | {
        checked: (string | number)[] | (() => (string | number)[]);
        halfChecked: (string | number)[] | (() => (string | number)[]);
    }>;
    /** 默认选中复选框的树节点 */
    defaultCheckedKeys: import("vue-types").VueTypeDef<(string | number)[]>;
    /** （受控）设置选中的树节点 */
    selectedKeys: import("vue-types").VueTypeDef<(string | number)[]>;
    /** 默认选中的树节点 */
    defaultSelectedKeys: import("vue-types").VueTypeDef<(string | number)[]>;
    selectable: import("vue-types").VueTypeValidableDef<boolean>;
    /** filter some AntTreeNodes as you need. it should return true */
    filterAntTreeNode: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    /** 异步加载数据 */
    loadData: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    loadedKeys: import("vue-types").VueTypeDef<(string | number)[]>;
    /** 响应右键点击 */
    /** 设置节点可拖拽（IE>8）*/
    draggable: import("vue-types").VueTypeValidableDef<boolean>;
    showIcon: import("vue-types").VueTypeValidableDef<boolean>;
    icon: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    switcherIcon: import("vue-types").VueTypeValidableDef<any>;
    prefixCls: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    filterTreeNode: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    openAnimation: import("vue-types").VueTypeValidableDef<any>;
    treeData: {
        type: PropType<TreeDataItem[]>;
    };
    /**
     * @default{title,key,children}
     * 替换treeNode中 title,key,children字段为treeData中对应的字段
     */
    replaceFields: import("vue-types").VueTypeValidableDef<{
        [key: string]: any;
    }> & {
        default: () => {
            [key: string]: any;
        };
    };
    blockNode: import("vue-types").VueTypeValidableDef<boolean>;
    /** 展开/收起节点时触发 */
    onExpand: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    /** 点击复选框触发 */
    onCheck: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    /** 点击树节点触发 */
    onSelect: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    /** 单击树节点触发 */
    onClick: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    /** 双击树节点触发 */
    onDoubleclick: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    onDblclick: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    'onUpdate:selectedKeys': import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    'onUpdate:checkedKeys': import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    'onUpdate:expandedKeys': import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
};
export { TreeProps };
declare const _default: import("vue").DefineComponent<{
    showLine: import("vue-types").VueTypeValidableDef<boolean>;
    /** 是否支持多选 */
    multiple: import("vue-types").VueTypeValidableDef<boolean>;
    /** 是否自动展开父节点 */
    autoExpandParent: import("vue-types").VueTypeValidableDef<boolean>;
    /** checkable状态下节点选择完全受控（父子节点选中状态不再关联）*/
    checkStrictly: import("vue-types").VueTypeValidableDef<boolean>;
    /** 是否支持选中 */
    checkable: import("vue-types").VueTypeValidableDef<boolean>;
    /** 是否禁用树 */
    disabled: import("vue-types").VueTypeValidableDef<boolean>;
    /** 默认展开所有树节点 */
    defaultExpandAll: import("vue-types").VueTypeValidableDef<boolean>;
    /** 默认展开对应树节点 */
    defaultExpandParent: import("vue-types").VueTypeValidableDef<boolean>;
    /** 默认展开指定的树节点 */
    defaultExpandedKeys: import("vue-types").VueTypeDef<(string | number)[]>;
    /** （受控）展开指定的树节点 */
    expandedKeys: import("vue-types").VueTypeDef<(string | number)[]>;
    /** （受控）选中复选框的树节点 */
    checkedKeys: import("vue-types").VueTypeDef<(string | number)[] | {
        checked: (string | number)[] | (() => (string | number)[]);
        halfChecked: (string | number)[] | (() => (string | number)[]);
    }>;
    /** 默认选中复选框的树节点 */
    defaultCheckedKeys: import("vue-types").VueTypeDef<(string | number)[]>;
    /** （受控）设置选中的树节点 */
    selectedKeys: import("vue-types").VueTypeDef<(string | number)[]>;
    /** 默认选中的树节点 */
    defaultSelectedKeys: import("vue-types").VueTypeDef<(string | number)[]>;
    selectable: import("vue-types").VueTypeValidableDef<boolean>;
    /** filter some AntTreeNodes as you need. it should return true */
    filterAntTreeNode: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    /** 异步加载数据 */
    loadData: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    loadedKeys: import("vue-types").VueTypeDef<(string | number)[]>;
    /** 响应右键点击 */
    /** 设置节点可拖拽（IE>8）*/
    draggable: import("vue-types").VueTypeValidableDef<boolean>;
    showIcon: import("vue-types").VueTypeValidableDef<boolean>;
    icon: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    switcherIcon: import("vue-types").VueTypeValidableDef<any>;
    prefixCls: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    filterTreeNode: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    openAnimation: import("vue-types").VueTypeValidableDef<any>;
    treeData: {
        type: PropType<TreeDataItem[]>;
    };
    /**
     * @default{title,key,children}
     * 替换treeNode中 title,key,children字段为treeData中对应的字段
     */
    replaceFields: import("vue-types").VueTypeValidableDef<{
        [key: string]: any;
    }> & {
        default: () => {
            [key: string]: any;
        };
    };
    blockNode: import("vue-types").VueTypeValidableDef<boolean>;
    /** 展开/收起节点时触发 */
    onExpand: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    /** 点击复选框触发 */
    onCheck: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    /** 点击树节点触发 */
    onSelect: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    /** 单击树节点触发 */
    onClick: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    /** 双击树节点触发 */
    onDoubleclick: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    onDblclick: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    'onUpdate:selectedKeys': import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    'onUpdate:checkedKeys': import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    'onUpdate:expandedKeys': import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
}, {
    tree: any;
    configProvider: import("../config-provider").ConfigConsumerProps;
}, unknown, {}, {
    renderSwitcherIcon(prefixCls: string, switcherIcon: VNode, { isLeaf, loading, expanded }: {
        isLeaf: any;
        loading: any;
        expanded: any;
    }): VNode<any, any, {
        [key: string]: any;
    }>;
    updateTreeData(treeData: TreeDataItem[]): any;
    setTreeRef(node: VNode): void;
    handleCheck(checkedObj: (number | string)[], eventObj: CheckEvent): void;
    handleExpand(expandedKeys: (number | string)[], eventObj: ExpendEvent): void;
    handleSelect(selectedKeys: (number | string)[], eventObj: SelectEvent): void;
}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, Record<string, any>, string, import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<{
    icon: (...args: any[]) => any;
    onClick: (...args: any[]) => any;
    onDblclick: (...args: any[]) => any;
    onSelect: (...args: any[]) => any;
    prefixCls: string;
    onExpand: (...args: any[]) => any;
    "onUpdate:selectedKeys": (...args: any[]) => any;
    loadData: (...args: any[]) => any;
    filterTreeNode: (...args: any[]) => any;
    replaceFields: {
        [key: string]: any;
    };
    filterAntTreeNode: (...args: any[]) => any;
    onCheck: (...args: any[]) => any;
    onDoubleclick: (...args: any[]) => any;
    "onUpdate:checkedKeys": (...args: any[]) => any;
    "onUpdate:expandedKeys": (...args: any[]) => any;
} & {
    multiple?: boolean;
    disabled?: boolean;
    showIcon?: boolean;
    draggable?: boolean;
    selectable?: boolean;
    openAnimation?: any;
    selectedKeys?: (string | number)[];
    defaultSelectedKeys?: (string | number)[];
    treeData?: TreeDataItem[];
    switcherIcon?: any;
    expandedKeys?: (string | number)[];
    autoExpandParent?: boolean;
    checkedKeys?: (string | number)[] | {
        checked: (string | number)[] | (() => (string | number)[]);
        halfChecked: (string | number)[] | (() => (string | number)[]);
    };
    loadedKeys?: (string | number)[];
    checkable?: boolean;
    blockNode?: boolean;
    showLine?: boolean;
    checkStrictly?: boolean;
    defaultExpandAll?: boolean;
    defaultExpandParent?: boolean;
    defaultExpandedKeys?: (string | number)[];
    defaultCheckedKeys?: (string | number)[];
}>, {
    icon: (...args: any[]) => any;
    onClick: (...args: any[]) => any;
    onDblclick: (...args: any[]) => any;
    onSelect: (...args: any[]) => any;
    prefixCls: string;
    onExpand: (...args: any[]) => any;
    "onUpdate:selectedKeys": (...args: any[]) => any;
    loadData: (...args: any[]) => any;
    filterTreeNode: (...args: any[]) => any;
    replaceFields: {
        [key: string]: any;
    };
    filterAntTreeNode: (...args: any[]) => any;
    onCheck: (...args: any[]) => any;
    onDoubleclick: (...args: any[]) => any;
    "onUpdate:checkedKeys": (...args: any[]) => any;
    "onUpdate:expandedKeys": (...args: any[]) => any;
}>;
export default _default;
