import { TypographyProps } from './Typography';
import { CSSProperties } from 'vue';
import { AutoSizeType } from '../input/ResizableTextArea';
export declare type BaseType = 'secondary' | 'success' | 'warning' | 'danger';
export interface CopyConfig {
    text?: string;
    onCopy?: () => void;
    tooltip?: boolean;
}
export interface EditConfig {
    editing?: boolean;
    tooltip?: boolean;
    onStart?: () => void;
    onChange?: (value: string) => void;
    onCancel?: () => void;
    onEnd?: () => void;
    maxlength?: number;
    autoSize?: boolean | AutoSizeType;
}
export interface EllipsisConfig {
    rows?: number;
    expandable?: boolean;
    suffix?: string;
    symbol?: string;
    onExpand?: EventHandlerNonNull;
    onEllipsis?: (ellipsis: boolean) => void;
    tooltip?: boolean;
}
export interface BlockProps extends TypographyProps {
    title?: string;
    editable?: boolean | EditConfig;
    copyable?: boolean | CopyConfig;
    type?: BaseType;
    disabled?: boolean;
    ellipsis?: boolean | EllipsisConfig;
    code?: boolean;
    mark?: boolean;
    underline?: boolean;
    delete?: boolean;
    strong?: boolean;
    keyboard?: boolean;
    content?: string;
}
interface InternalBlockProps extends BlockProps {
    component: string;
}
declare const Base: import("vue").DefineComponent<InternalBlockProps, {}, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, import("vue").EmitsOptions, string, import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<{
    class: any;
    inlist: any;
} & {
    style?: string | CSSProperties | (string | CSSProperties | (string | CSSProperties | (string | CSSProperties | (string | CSSProperties | (string | CSSProperties | (string | CSSProperties | (string | CSSProperties | (string | CSSProperties | (string | CSSProperties | (string | CSSProperties | (string | CSSProperties | any)[])[])[])[])[])[])[])[])[])[])[];
    code?: boolean;
    mark?: boolean;
    strong?: boolean;
    title?: string;
    onCopy?: (payload: ClipboardEvent) => void;
    onCut?: (payload: ClipboardEvent) => void;
    onPaste?: (payload: ClipboardEvent) => void;
    onCompositionend?: (payload: CompositionEvent) => void;
    onCompositionstart?: (payload: CompositionEvent) => void;
    onCompositionupdate?: (payload: CompositionEvent) => void;
    onDrag?: (payload: DragEvent) => void;
    onDragend?: (payload: DragEvent) => void;
    onDragenter?: (payload: DragEvent) => void;
    onDragexit?: (payload: DragEvent) => void;
    onDragleave?: (payload: DragEvent) => void;
    onDragover?: (payload: DragEvent) => void;
    onDragstart?: (payload: DragEvent) => void;
    onDrop?: (payload: DragEvent) => void;
    onFocus?: (payload: FocusEvent) => void;
    onFocusin?: (payload: FocusEvent) => void;
    onFocusout?: (payload: FocusEvent) => void;
    onBlur?: (payload: FocusEvent) => void;
    onChange?: (payload: Event) => void;
    onBeforeinput?: (payload: Event) => void;
    onInput?: (payload: Event) => void;
    onReset?: (payload: Event) => void;
    onSubmit?: (payload: Event) => void;
    onInvalid?: (payload: Event) => void;
    onLoad?: (payload: Event) => void;
    onError?: (payload: Event) => void;
    onKeydown?: (payload: KeyboardEvent) => void;
    onKeypress?: (payload: KeyboardEvent) => void;
    onKeyup?: (payload: KeyboardEvent) => void;
    onAuxclick?: (payload: MouseEvent) => void;
    onClick?: (payload: MouseEvent) => void;
    onContextmenu?: (payload: MouseEvent) => void;
    onDblclick?: (payload: MouseEvent) => void;
    onMousedown?: (payload: MouseEvent) => void;
    onMouseenter?: (payload: MouseEvent) => void;
    onMouseleave?: (payload: MouseEvent) => void;
    onMousemove?: (payload: MouseEvent) => void;
    onMouseout?: (payload: MouseEvent) => void;
    onMouseover?: (payload: MouseEvent) => void;
    onMouseup?: (payload: MouseEvent) => void;
    onAbort?: (payload: Event) => void;
    onCanplay?: (payload: Event) => void;
    onCanplaythrough?: (payload: Event) => void;
    onDurationchange?: (payload: Event) => void;
    onEmptied?: (payload: Event) => void;
    onEncrypted?: (payload: Event) => void;
    onEnded?: (payload: Event) => void;
    onLoadeddata?: (payload: Event) => void;
    onLoadedmetadata?: (payload: Event) => void;
    onLoadstart?: (payload: Event) => void;
    onPause?: (payload: Event) => void;
    onPlay?: (payload: Event) => void;
    onPlaying?: (payload: Event) => void;
    onProgress?: (payload: Event) => void;
    onRatechange?: (payload: Event) => void;
    onSeeked?: (payload: Event) => void;
    onSeeking?: (payload: Event) => void;
    onStalled?: (payload: Event) => void;
    onSuspend?: (payload: Event) => void;
    onTimeupdate?: (payload: Event) => void;
    onVolumechange?: (payload: Event) => void;
    onWaiting?: (payload: Event) => void;
    onSelect?: (payload: Event) => void;
    onScroll?: (payload: UIEvent) => void;
    onTouchcancel?: (payload: TouchEvent) => void;
    onTouchend?: (payload: TouchEvent) => void;
    onTouchmove?: (payload: TouchEvent) => void;
    onTouchstart?: (payload: TouchEvent) => void;
    onPointerdown?: (payload: PointerEvent) => void;
    onPointermove?: (payload: PointerEvent) => void;
    onPointerup?: (payload: PointerEvent) => void;
    onPointercancel?: (payload: PointerEvent) => void;
    onPointerenter?: (payload: PointerEvent) => void;
    onPointerleave?: (payload: PointerEvent) => void;
    onPointerover?: (payload: PointerEvent) => void;
    onPointerout?: (payload: PointerEvent) => void;
    onWheel?: (payload: WheelEvent) => void;
    onAnimationstart?: (payload: AnimationEvent) => void;
    onAnimationend?: (payload: AnimationEvent) => void;
    onAnimationiteration?: (payload: AnimationEvent) => void;
    onTransitionend?: (payload: TransitionEvent) => void;
    onTransitionstart?: (payload: TransitionEvent) => void;
    prefixCls?: string;
    keyboard?: boolean;
    role?: string;
    hidden?: boolean;
    color?: string;
    ellipsis?: boolean | EllipsisConfig;
    content?: string;
    underline?: boolean;
    disabled?: boolean;
    contextmenu?: string;
    component?: string;
    id?: string;
    type?: BaseType;
    editable?: boolean | EditConfig;
    tabindex?: string | number;
    placeholder?: string;
    prefix?: string;
    dir?: string;
    innerHTML?: string;
    accesskey?: string;
    contenteditable?: "inherit" | (boolean | "false" | "true");
    draggable?: boolean | "false" | "true";
    lang?: string;
    spellcheck?: boolean | "false" | "true";
    translate?: "yes" | "no";
    radiogroup?: string;
    about?: string;
    datatype?: string;
    property?: string;
    resource?: string;
    typeof?: string;
    vocab?: string;
    autocapitalize?: string;
    autocorrect?: string;
    autocave?: string;
    itemprop?: string;
    itemscope?: boolean;
    itemtype?: string;
    itemid?: string;
    itemref?: string;
    results?: number;
    security?: string;
    unselectable?: "on" | "off";
    inputmode?: "text" | "none" | "search" | "tel" | "url" | "email" | "numeric" | "decimal";
    is?: string;
    "aria-activedescendant"?: string;
    "aria-atomic"?: boolean | "false" | "true";
    "aria-autocomplete"?: "none" | "inline" | "both" | "list";
    "aria-busy"?: boolean | "false" | "true";
    "aria-checked"?: boolean | "false" | "true" | "mixed";
    "aria-colcount"?: number;
    "aria-colindex"?: number;
    "aria-colspan"?: number;
    "aria-controls"?: string;
    "aria-current"?: boolean | "time" | "false" | "true" | "page" | "step" | "location" | "date";
    "aria-describedby"?: string;
    "aria-details"?: string;
    "aria-disabled"?: boolean | "false" | "true";
    "aria-dropeffect"?: "link" | "none" | "copy" | "move" | "popup" | "execute";
    "aria-errormessage"?: string;
    "aria-expanded"?: boolean | "false" | "true";
    "aria-flowto"?: string;
    "aria-grabbed"?: boolean | "false" | "true";
    "aria-haspopup"?: boolean | "dialog" | "menu" | "false" | "true" | "grid" | "listbox" | "tree";
    "aria-hidden"?: boolean | "false" | "true";
    "aria-invalid"?: boolean | "false" | "true" | "grammar" | "spelling";
    "aria-keyshortcuts"?: string;
    "aria-label"?: string;
    "aria-labelledby"?: string;
    "aria-level"?: number;
    "aria-live"?: "off" | "polite" | "assertive";
    "aria-modal"?: boolean | "false" | "true";
    "aria-multiline"?: boolean | "false" | "true";
    "aria-multiselectable"?: boolean | "false" | "true";
    "aria-orientation"?: "horizontal" | "vertical";
    "aria-owns"?: string;
    "aria-placeholder"?: string;
    "aria-posinset"?: number;
    "aria-pressed"?: boolean | "false" | "true" | "mixed";
    "aria-readonly"?: boolean | "false" | "true";
    "aria-relevant"?: "text" | "all" | "additions" | "additions text" | "removals";
    "aria-required"?: boolean | "false" | "true";
    "aria-roledescription"?: string;
    "aria-rowcount"?: number;
    "aria-rowindex"?: number;
    "aria-rowspan"?: number;
    "aria-selected"?: boolean | "false" | "true";
    "aria-setsize"?: number;
    "aria-sort"?: "none" | "ascending" | "descending" | "other";
    "aria-valuemax"?: number;
    "aria-valuemin"?: number;
    "aria-valuenow"?: number;
    "aria-valuetext"?: string;
    copyable?: boolean | CopyConfig;
    delete?: boolean;
}>, {
    class: any;
    inlist: any;
}>;
export declare const baseProps: () => {
    editable: import("vue-types").VueTypeDef<boolean | {
        [key: string]: any;
    }>;
    copyable: import("vue-types").VueTypeDef<boolean | {
        [key: string]: any;
    }>;
    prefixCls: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    component: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    type: import("vue-types").VueTypeDef<string>;
    disabled: import("vue-types").VueTypeValidableDef<boolean>;
    ellipsis: import("vue-types").VueTypeDef<boolean | {
        [key: string]: any;
    }>;
    code: import("vue-types").VueTypeValidableDef<boolean>;
    mark: import("vue-types").VueTypeValidableDef<boolean>;
    underline: import("vue-types").VueTypeValidableDef<boolean>;
    delete: import("vue-types").VueTypeValidableDef<boolean>;
    strong: import("vue-types").VueTypeValidableDef<boolean>;
    keyboard: import("vue-types").VueTypeValidableDef<boolean>;
    content: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
};
export default Base;
