import { createVNode as _createVNode } from "vue";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

import PropTypes from '../_util/vue-types';
import { getComponent, getSlot } from '../_util/props-util';
import { menuAllProps } from './util';
import { defineComponent, inject } from 'vue';
import classNames from '../_util/classNames';
import { injectExtraPropsKey } from './FunctionProvider';
var MenuItemGroup = {
  name: 'MenuItemGroup',
  inheritAttrs: false,
  setup: function setup() {
    return {
      injectExtraProps: inject(injectExtraPropsKey, function () {
        return {};
      })
    };
  },
  props: {
    renderMenuItem: PropTypes.func,
    index: PropTypes.number,
    className: PropTypes.string,
    subMenuKey: PropTypes.string,
    rootPrefixCls: PropTypes.string,
    disabled: PropTypes.looseBool.def(true),
    title: PropTypes.any
  },
  isMenuItemGroup: true,
  methods: {
    renderInnerMenuItem: function renderInnerMenuItem(item) {
      var _Object$assign = _extends(_extends({}, this.$props), this.injectExtraProps),
          renderMenuItem = _Object$assign.renderMenuItem,
          index = _Object$assign.index,
          subMenuKey = _Object$assign.subMenuKey;

      return renderMenuItem(item, index, subMenuKey);
    }
  },
  render: function render() {
    var props = _extends(_extends(_extends({}, this.$props), this.injectExtraProps), this.$attrs);

    var _props$class = props.class,
        cls = _props$class === void 0 ? '' : _props$class,
        rootPrefixCls = props.rootPrefixCls,
        title = props.title;
    var titleClassName = "".concat(rootPrefixCls, "-item-group-title");
    var listClassName = "".concat(rootPrefixCls, "-item-group-list");
    menuAllProps.forEach(function (key) {
      return delete props[key];
    }); // Set onClick to null, to ignore propagated onClick event

    delete props.onClick;
    var children = getSlot(this);
    return _createVNode("li", _objectSpread(_objectSpread({}, props), {}, {
      "class": classNames(cls, "".concat(rootPrefixCls, "-item-group"))
    }), [_createVNode("div", {
      "class": titleClassName,
      "title": typeof title === 'string' ? title : undefined
    }, [getComponent(this, 'title')]), _createVNode("ul", {
      "class": listClassName
    }, [children && children.map(this.renderInnerMenuItem)])]);
  }
};
export default defineComponent(MenuItemGroup);