import { PropType, Component, CSSProperties } from 'vue';
import { Key } from '../_util/type';
export interface ListState<T = object> {
    scrollTop: number;
    scrollMoving: boolean;
    mergedData: T[];
}
declare const List: import("vue").DefineComponent<{
    prefixCls: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    data: import("vue-types").VueTypeValidableDef<unknown[]> & {
        default: () => unknown[];
    };
    height: import("vue-types").VueTypeValidableDef<number> & {
        default: number;
    };
    itemHeight: import("vue-types").VueTypeValidableDef<number> & {
        default: number;
    };
    /** If not match virtual scroll condition, Set List still use height of container. */
    fullHeight: import("vue-types").VueTypeValidableDef<boolean>;
    itemKey: {
        type: PropType<Key | ((item: object) => Key)>;
        required: true;
    };
    component: {
        type: PropType<string | Component<any, any, any, import("vue").ComputedOptions, import("vue").MethodOptions>>;
    };
    /** Set `false` will always use real scroll instead of virtual one */
    virtual: import("vue-types").VueTypeValidableDef<boolean>;
    children: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    onScroll: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    onMousedown: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    onMouseenter: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
}, {
    state: {
        scrollTop: number;
        scrollMoving: boolean;
        mergedData: (object & {})[];
    };
    componentStyle: import("vue").ComputedRef<CSSProperties>;
    scrollTo: (arg?: any) => void;
    onFallbackScroll: (e: UIEvent) => void;
    onScrollBar: (newScrollTop: number) => void;
    componentRef: import("vue").Ref<HTMLDivElement>;
    useVirtual: import("vue").ComputedRef<boolean>;
    calRes: import("vue").Ref<any>;
    collectHeight: () => void;
    setInstance: (item: Record<string, any>, instance: HTMLElement) => void;
    sharedConfig: {
        getKey: (item: Record<string, any>) => any;
    };
    scrollBarRef: import("vue").Ref<any>;
    fillerInnerRef: import("vue").Ref<HTMLDivElement>;
}, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, Record<string, any>, string, import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<{
    children: (...args: any[]) => any;
    data: unknown[];
    onMousedown: (...args: any[]) => any;
    onMouseenter: (...args: any[]) => any;
    onScroll: (...args: any[]) => any;
    prefixCls: string;
    height: number;
    itemHeight: number;
    itemKey: Key | ((item: object) => Key);
} & {
    fullHeight?: boolean;
    component?: unknown;
    virtual?: boolean;
}>, {
    children: (...args: any[]) => any;
    data: unknown[];
    onMousedown: (...args: any[]) => any;
    onMouseenter: (...args: any[]) => any;
    onScroll: (...args: any[]) => any;
    prefixCls: string;
    height: number;
    itemHeight: number;
}>;
export default List;
