"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _vue = require("vue");

var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));

var _classNames = _interopRequireDefault(require("../_util/classNames"));

var _addEventListener = _interopRequireDefault(require("../vc-util/Dom/addEventListener"));

var _affix = _interopRequireDefault(require("../affix"));

var _scrollTo = _interopRequireDefault(require("../_util/scrollTo"));

var _getScroll = _interopRequireDefault(require("../_util/getScroll"));

var _propsUtil = require("../_util/props-util");

var _BaseMixin = _interopRequireDefault(require("../_util/BaseMixin"));

var _configProvider = require("../config-provider");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function getDefaultContainer() {
  return window;
}

function getOffsetTop(element, container) {
  if (!element) {
    return 0;
  }

  if (!element.getClientRects().length) {
    return 0;
  }

  var rect = element.getBoundingClientRect();

  if (rect.width || rect.height) {
    if (container === window) {
      container = element.ownerDocument.documentElement;
      return rect.top - container.clientTop;
    }

    return rect.top - container.getBoundingClientRect().top;
  }

  return rect.top;
}

var sharpMatcherRegx = /#([^#]+)$/;
var AnchorProps = {
  prefixCls: _vueTypes.default.string,
  offsetTop: _vueTypes.default.number,
  bounds: _vueTypes.default.number,
  affix: _vueTypes.default.looseBool.def(true),
  showInkInFixed: _vueTypes.default.looseBool.def(false),
  getContainer: _vueTypes.default.func.def(getDefaultContainer),
  wrapperClass: _vueTypes.default.string,
  wrapperStyle: _vueTypes.default.style,
  getCurrentAnchor: _vueTypes.default.func,
  targetOffset: _vueTypes.default.number,
  onChange: _vueTypes.default.func,
  onClick: _vueTypes.default.func
};

var _default2 = (0, _vue.defineComponent)({
  name: 'AAnchor',
  mixins: [_BaseMixin.default],
  inheritAttrs: false,
  props: AnchorProps,
  emits: ['change', 'click'],
  setup: function setup() {
    return {
      configProvider: (0, _vue.inject)('configProvider', _configProvider.defaultConfigProvider)
    };
  },
  data: function data() {
    // this.links = [];
    // this.sPrefixCls = '';
    return {
      activeLink: null,
      links: [],
      sPrefixCls: '',
      scrollContainer: null,
      scrollEvent: null,
      animating: false
    };
  },
  created: function created() {
    var _this = this;

    (0, _vue.provide)('antAnchor', {
      registerLink: function registerLink(link) {
        if (!_this.links.includes(link)) {
          _this.links.push(link);
        }
      },
      unregisterLink: function unregisterLink(link) {
        var index = _this.links.indexOf(link);

        if (index !== -1) {
          _this.links.splice(index, 1);
        }
      },
      $data: this.$data,
      scrollTo: this.handleScrollTo
    });
    (0, _vue.provide)('antAnchorContext', this);
  },
  mounted: function mounted() {
    var _this2 = this;

    (0, _vue.nextTick)(function () {
      var getContainer = _this2.getContainer;
      _this2.scrollContainer = getContainer();
      _this2.scrollEvent = (0, _addEventListener.default)(_this2.scrollContainer, 'scroll', _this2.handleScroll);

      _this2.handleScroll();
    });
  },
  updated: function updated() {
    var _this3 = this;

    (0, _vue.nextTick)(function () {
      if (_this3.scrollEvent) {
        var getContainer = _this3.getContainer;
        var currentContainer = getContainer();

        if (_this3.scrollContainer !== currentContainer) {
          _this3.scrollContainer = currentContainer;

          _this3.scrollEvent.remove();

          _this3.scrollEvent = (0, _addEventListener.default)(_this3.scrollContainer, 'scroll', _this3.handleScroll);

          _this3.handleScroll();
        }
      }

      _this3.updateInk();
    });
  },
  beforeUnmount: function beforeUnmount() {
    if (this.scrollEvent) {
      this.scrollEvent.remove();
    }
  },
  methods: {
    getCurrentActiveLink: function getCurrentActiveLink() {
      var offsetTop = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
      var bounds = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 5;
      var getCurrentAnchor = this.getCurrentAnchor;

      if (typeof getCurrentAnchor === 'function') {
        return getCurrentAnchor();
      }

      var activeLink = '';

      if (typeof document === 'undefined') {
        return activeLink;
      }

      var linkSections = [];
      var getContainer = this.getContainer;
      var container = getContainer();
      this.links.forEach(function (link) {
        var sharpLinkMatch = sharpMatcherRegx.exec(link.toString());

        if (!sharpLinkMatch) {
          return;
        }

        var target = document.getElementById(sharpLinkMatch[1]);

        if (target) {
          var top = getOffsetTop(target, container);

          if (top < offsetTop + bounds) {
            linkSections.push({
              link: link,
              top: top
            });
          }
        }
      });

      if (linkSections.length) {
        var maxSection = linkSections.reduce(function (prev, curr) {
          return curr.top > prev.top ? curr : prev;
        });
        return maxSection.link;
      }

      return '';
    },
    handleScrollTo: function handleScrollTo(link) {
      var _this4 = this;

      var offsetTop = this.offsetTop,
          getContainer = this.getContainer,
          targetOffset = this.targetOffset;
      this.setCurrentActiveLink(link);
      var container = getContainer();
      var scrollTop = (0, _getScroll.default)(container, true);
      var sharpLinkMatch = sharpMatcherRegx.exec(link);

      if (!sharpLinkMatch) {
        return;
      }

      var targetElement = document.getElementById(sharpLinkMatch[1]);

      if (!targetElement) {
        return;
      }

      var eleOffsetTop = getOffsetTop(targetElement, container);
      var y = scrollTop + eleOffsetTop;
      y -= targetOffset !== undefined ? targetOffset : offsetTop || 0;
      this.animating = true;
      (0, _scrollTo.default)(y, {
        callback: function callback() {
          _this4.animating = false;
        },
        getContainer: getContainer
      });
    },
    setCurrentActiveLink: function setCurrentActiveLink(link) {
      var activeLink = this.activeLink;

      if (activeLink !== link) {
        this.setState({
          activeLink: link
        });
        this.$emit('change', link);
      }
    },
    handleScroll: function handleScroll() {
      if (this.animating) {
        return;
      }

      var offsetTop = this.offsetTop,
          bounds = this.bounds,
          targetOffset = this.targetOffset;
      var currentActiveLink = this.getCurrentActiveLink(targetOffset !== undefined ? targetOffset : offsetTop || 0, bounds);
      this.setCurrentActiveLink(currentActiveLink);
    },
    updateInk: function updateInk() {
      if (typeof document === 'undefined') {
        return;
      }

      var sPrefixCls = this.sPrefixCls;
      var linkNode = (0, _propsUtil.findDOMNode)(this).getElementsByClassName("".concat(sPrefixCls, "-link-title-active"))[0];

      if (linkNode) {
        this.$refs.inkNode.style.top = "".concat(linkNode.offsetTop + linkNode.clientHeight / 2 - 4.5, "px");
      }
    }
  },
  render: function render() {
    var _a;

    var customizePrefixCls = this.prefixCls,
        offsetTop = this.offsetTop,
        affix = this.affix,
        showInkInFixed = this.showInkInFixed,
        activeLink = this.activeLink,
        $slots = this.$slots,
        getContainer = this.getContainer;
    var getPrefixCls = this.configProvider.getPrefixCls;
    var prefixCls = getPrefixCls('anchor', customizePrefixCls);
    this.sPrefixCls = prefixCls;
    var inkClass = (0, _classNames.default)("".concat(prefixCls, "-ink-ball"), {
      visible: activeLink
    });
    var wrapperClass = (0, _classNames.default)(this.wrapperClass, "".concat(prefixCls, "-wrapper"));
    var anchorClass = (0, _classNames.default)(prefixCls, {
      fixed: !affix && !showInkInFixed
    });

    var wrapperStyle = _extends({
      maxHeight: offsetTop ? "calc(100vh - ".concat(offsetTop, "px)") : '100vh'
    }, this.wrapperStyle);

    var anchorContent = (0, _vue.createVNode)("div", {
      "class": wrapperClass,
      "style": wrapperStyle
    }, [(0, _vue.createVNode)("div", {
      "class": anchorClass
    }, [(0, _vue.createVNode)("div", {
      "class": "".concat(prefixCls, "-ink")
    }, [(0, _vue.createVNode)("span", {
      "class": inkClass,
      "ref": "inkNode"
    }, null)]), (_a = $slots.default) === null || _a === void 0 ? void 0 : _a.call($slots)])]);
    return !affix ? anchorContent : (0, _vue.createVNode)(_affix.default, _objectSpread(_objectSpread({}, this.$attrs), {}, {
      "offsetTop": offsetTop,
      "target": getContainer
    }), {
      default: function _default() {
        return [anchorContent];
      }
    });
  }
});

exports.default = _default2;