"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _vue = require("vue");

var _classNames = _interopRequireDefault(require("../_util/classNames"));

var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));

var _backTopTypes = _interopRequireDefault(require("./backTopTypes"));

var _addEventListener = _interopRequireDefault(require("../vc-util/Dom/addEventListener"));

var _getScroll = _interopRequireDefault(require("../_util/getScroll"));

var _BaseMixin = _interopRequireDefault(require("../_util/BaseMixin"));

var _transition = require("../_util/transition");

var _configProvider = require("../config-provider");

var _scrollTo = _interopRequireDefault(require("../_util/scrollTo"));

var _type = require("../_util/type");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function getDefaultTarget() {
  return window;
}

var props = (0, _backTopTypes.default)();
var BackTop = (0, _vue.defineComponent)({
  name: 'ABackTop',
  mixins: [_BaseMixin.default],
  inheritAttrs: false,
  props: _extends(_extends({}, props), {
    visibilityHeight: _vueTypes.default.number.def(400)
  }),
  emits: ['click'],
  setup: function setup() {
    return {
      configProvider: (0, _vue.inject)('configProvider', _configProvider.defaultConfigProvider)
    };
  },
  data: function data() {
    return {
      visible: false,
      scrollEvent: null
    };
  },
  mounted: function mounted() {
    var _this = this;

    (0, _vue.nextTick)(function () {
      var getTarget = _this.target || getDefaultTarget;
      _this.scrollEvent = (0, _addEventListener.default)(getTarget(), 'scroll', _this.handleScroll);

      _this.handleScroll();
    });
  },
  activated: function activated() {
    var _this2 = this;

    (0, _vue.nextTick)(function () {
      _this2.handleScroll();
    });
  },
  beforeUnmount: function beforeUnmount() {
    if (this.scrollEvent) {
      this.scrollEvent.remove();
    }
  },
  methods: {
    getCurrentScrollTop: function getCurrentScrollTop() {
      var getTarget = this.target || getDefaultTarget;
      var targetNode = getTarget();

      if (targetNode === window) {
        return window.pageYOffset || document.body.scrollTop || document.documentElement.scrollTop;
      }

      return targetNode.scrollTop;
    },
    scrollToTop: function scrollToTop(e) {
      var _this$target = this.target,
          target = _this$target === void 0 ? getDefaultTarget : _this$target;
      (0, _scrollTo.default)(0, {
        getContainer: target
      });
      this.$emit('click', e);
    },
    handleScroll: function handleScroll() {
      var visibilityHeight = this.visibilityHeight,
          _this$target2 = this.target,
          target = _this$target2 === void 0 ? getDefaultTarget : _this$target2;
      var scrollTop = (0, _getScroll.default)(target(), true);
      this.setState({
        visible: scrollTop > visibilityHeight
      });
    }
  },
  render: function render() {
    var _a;

    var customizePrefixCls = this.prefixCls,
        $slots = this.$slots;
    var getPrefixCls = this.configProvider.getPrefixCls;
    var prefixCls = getPrefixCls('back-top', customizePrefixCls);
    var classString = (0, _classNames.default)(prefixCls, this.$attrs.class);
    var defaultElement = (0, _vue.createVNode)("div", {
      "class": "".concat(prefixCls, "-content")
    }, [(0, _vue.createVNode)("div", {
      "class": "".concat(prefixCls, "-icon")
    }, null)]);

    var divProps = _extends(_extends({}, this.$attrs), {
      onClick: this.scrollToTop,
      class: classString
    });

    var backTopBtn = this.visible ? (0, _vue.createVNode)("div", divProps, [((_a = $slots.default) === null || _a === void 0 ? void 0 : _a.call($slots)) || defaultElement]) : null;
    var transitionProps = (0, _transition.getTransitionProps)('fade');
    return (0, _vue.createVNode)(_transition.Transition, transitionProps, {
      default: function _default() {
        return [backTopBtn];
      }
    });
  }
});

var _default2 = (0, _type.withInstall)(BackTop);

exports.default = _default2;