"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _vue = require("vue");

var _classNames = _interopRequireDefault(require("../_util/classNames"));

var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));

var _BaseMixin = _interopRequireDefault(require("../_util/BaseMixin"));

var _omit = _interopRequireDefault(require("omit.js"));

var _vnode = require("../_util/vnode");

var _configProvider = require("../config-provider");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function getNumberArray(num) {
  return num ? num.toString().split('').reverse().map(function (i) {
    var current = Number(i);
    return isNaN(current) ? i : current;
  }) : [];
}

var ScrollNumberProps = {
  prefixCls: _vueTypes.default.string,
  count: _vueTypes.default.any,
  component: _vueTypes.default.string,
  title: _vueTypes.default.oneOfType([_vueTypes.default.number, _vueTypes.default.string, null]),
  displayComponent: _vueTypes.default.any,
  onAnimated: _vueTypes.default.func
};

var _default2 = (0, _vue.defineComponent)({
  name: 'ScrollNumber',
  mixins: [_BaseMixin.default],
  inheritAttrs: false,
  props: ScrollNumberProps,
  emits: ['animated'],
  setup: function setup() {
    return {
      configProvider: (0, _vue.inject)('configProvider', _configProvider.defaultConfigProvider),
      lastCount: undefined,
      timeout: undefined
    };
  },
  data: function data() {
    return {
      animateStarted: true,
      sCount: this.count
    };
  },
  watch: {
    count: function count() {
      this.lastCount = this.sCount;
      this.setState({
        animateStarted: true
      });
    }
  },
  updated: function updated() {
    var _this = this;

    var animateStarted = this.animateStarted,
        count = this.count;

    if (animateStarted) {
      this.clearTimeout(); // Let browser has time to reset the scroller before actually
      // performing the transition.

      this.timeout = setTimeout(function () {
        _this.setState({
          animateStarted: false,
          sCount: count
        }, _this.handleAnimated);
      });
    }
  },
  beforeUnmount: function beforeUnmount() {
    this.clearTimeout();
  },
  methods: {
    clearTimeout: function (_clearTimeout) {
      function clearTimeout() {
        return _clearTimeout.apply(this, arguments);
      }

      clearTimeout.toString = function () {
        return _clearTimeout.toString();
      };

      return clearTimeout;
    }(function () {
      if (this.timeout) {
        clearTimeout(this.timeout);
        this.timeout = undefined;
      }
    }),
    getPositionByNum: function getPositionByNum(num, i) {
      var sCount = this.sCount;
      var currentCount = Math.abs(Number(sCount));
      var lastCount = Math.abs(Number(this.lastCount));
      var currentDigit = Math.abs(getNumberArray(sCount)[i]);
      var lastDigit = Math.abs(getNumberArray(this.lastCount)[i]);

      if (this.animateStarted) {
        return 10 + num;
      } // 同方向则在同一侧切换数字


      if (currentCount > lastCount) {
        if (currentDigit >= lastDigit) {
          return 10 + num;
        }

        return 20 + num;
      }

      if (currentDigit <= lastDigit) {
        return 10 + num;
      }

      return num;
    },
    handleAnimated: function handleAnimated() {
      this.$emit('animated');
    },
    renderNumberList: function renderNumberList(position, className) {
      var childrenToReturn = [];

      for (var i = 0; i < 30; i++) {
        childrenToReturn.push((0, _vue.createVNode)("p", {
          "key": i.toString(),
          "class": (0, _classNames.default)(className, {
            current: position === i
          })
        }, [i % 10]));
      }

      return childrenToReturn;
    },
    renderCurrentNumber: function renderCurrentNumber(prefixCls, num, i) {
      if (typeof num === 'number') {
        var position = this.getPositionByNum(num, i);
        var removeTransition = this.animateStarted || getNumberArray(this.lastCount)[i] === undefined;
        var style = {
          transition: removeTransition ? 'none' : undefined,
          msTransform: "translateY(".concat(-position * 100, "%)"),
          WebkitTransform: "translateY(".concat(-position * 100, "%)"),
          transform: "translateY(".concat(-position * 100, "%)")
        };
        return (0, _vue.createVNode)("span", {
          "class": "".concat(prefixCls, "-only"),
          "style": style,
          "key": i
        }, [this.renderNumberList(position, "".concat(prefixCls, "-only-unit"))]);
      }

      return (0, _vue.createVNode)("span", {
        "key": "symbol",
        "class": "".concat(prefixCls, "-symbol")
      }, [num]);
    },
    renderNumberElement: function renderNumberElement(prefixCls) {
      var _this2 = this;

      var sCount = this.sCount;

      if (sCount && Number(sCount) % 1 === 0) {
        return getNumberArray(sCount).map(function (num, i) {
          return _this2.renderCurrentNumber(prefixCls, num, i);
        }).reverse();
      }

      return sCount;
    }
  },
  render: function render() {
    var _this3 = this;

    var customizePrefixCls = this.prefixCls,
        title = this.title,
        _this$component = this.component,
        Tag = _this$component === void 0 ? 'sup' : _this$component,
        displayComponent = this.displayComponent;
    var getPrefixCls = this.configProvider.getPrefixCls;
    var prefixCls = getPrefixCls('scroll-number', customizePrefixCls);
    var _this$$attrs = this.$attrs,
        className = _this$$attrs.class,
        _this$$attrs$style = _this$$attrs.style,
        style = _this$$attrs$style === void 0 ? {} : _this$$attrs$style;

    if (displayComponent) {
      return (0, _vnode.cloneElement)(displayComponent, {
        class: (0, _classNames.default)("".concat(prefixCls, "-custom-component"), displayComponent.props && displayComponent.props.class)
      });
    } // fix https://fb.me/react-unknown-prop


    var restProps = (0, _omit.default)(_extends(_extends({}, this.$props), this.$attrs), ['count', 'onAnimated', 'component', 'prefixCls', 'displayComponent']);

    var tempStyle = _extends({}, style);

    var newProps = _extends(_extends({}, restProps), {
      title: title,
      style: tempStyle,
      class: (0, _classNames.default)(prefixCls, className)
    }); // allow specify the border
    // mock border-color by box-shadow for compatible with old usage:
    // <Badge count={4} style={{ backgroundColor: '#fff', color: '#999', borderColor: '#d9d9d9' }} />


    if (style && style.borderColor) {
      newProps.style.boxShadow = "0 0 0 1px ".concat(style.borderColor, " inset");
    }

    return (0, _vue.createVNode)(Tag, newProps, {
      default: function _default() {
        return [_this3.renderNumberElement(prefixCls)];
      }
    });
  }
});

exports.default = _default2;